/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.okhttp;

import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.glowroot.instrumentation.api.AsyncSpan;
import org.glowroot.instrumentation.okhttp.OkHttp3xResponseGetter;
import org.glowroot.instrumentation.okhttp.boot.HttpRequestMessageSupplier;

class OkHttp3xCallbackWrapperForNullDelegate
implements Callback {
    private final AsyncSpan span;

    OkHttp3xCallbackWrapperForNullDelegate(AsyncSpan span) {
        this.span = span;
    }

    public void onFailure(Call call, IOException exception) {
        this.span.endWithError(exception);
    }

    public void onResponse(Call call, Response response) throws IOException {
        HttpRequestMessageSupplier supplier = (HttpRequestMessageSupplier)this.span.getMessageSupplier();
        if (supplier != null) {
            supplier.setStatusCode(response.code());
        }
        this.span.extractFromResponse(response, OkHttp3xResponseGetter.INSTANCE);
        this.span.end();
    }
}

