/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.okhttp;

import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.glowroot.instrumentation.api.Agent;
import org.glowroot.instrumentation.api.AsyncSpan;
import org.glowroot.instrumentation.api.ParameterHolder;
import org.glowroot.instrumentation.api.Setter;
import org.glowroot.instrumentation.api.Span;
import org.glowroot.instrumentation.api.ThreadContext;
import org.glowroot.instrumentation.api.TimerName;
import org.glowroot.instrumentation.api.checker.Nullable;
import org.glowroot.instrumentation.api.weaving.Advice;
import org.glowroot.instrumentation.api.weaving.Bind;
import org.glowroot.instrumentation.api.weaving.Mixin;
import org.glowroot.instrumentation.okhttp.OkHttp3xCallbackWrapper;
import org.glowroot.instrumentation.okhttp.OkHttp3xCallbackWrapperForNullDelegate;
import org.glowroot.instrumentation.okhttp.boot.HttpRequestMessageSupplier;
import org.glowroot.instrumentation.okhttp.boot.Util;

public class OkHttp3xInstrumentation {
    private static final TimerName TIMER_NAME = Agent.getTimerName("http client request");
    private static final Setter<Map<String, String>> SETTER = new SetterImpl();

    private static Callback createWrapper(ParameterHolder<Callback> callback, AsyncSpan span, ThreadContext context) {
        Callback delegate = callback.get();
        if (delegate == null) {
            return new OkHttp3xCallbackWrapperForNullDelegate(span);
        }
        return new OkHttp3xCallbackWrapper(delegate, span, context.createAuxThreadContext());
    }

    private static class SetterImpl
    implements Setter<Map<String, String>> {
        private SetterImpl() {
        }

        @Override
        public void put(Map<String, String> carrier, String key, String value) {
            carrier.put(key, value);
        }
    }

    @Advice.Pointcut(className="okhttp3.internal.http.RealInterceptorChain|okhttp3.RealCall$ApplicationInterceptorChain", methodName="proceed", methodParameterTypes={"okhttp3.Request"})
    public static class PropagateAdvice {
        @Advice.OnMethodBefore
        public static void onBefore(@Bind.This Interceptor.Chain chain, @Bind.Argument(value=0) ParameterHolder<Request> requestHolder) {
            RequestMixin requestMixin = (RequestMixin)RequestMixin.class.cast(chain.request());
            Map<String, String> extraHeaders = requestMixin.glowroot$getExtraHeaders();
            if (extraHeaders == null) {
                return;
            }
            Request request = requestHolder.get();
            if (request == null) {
                return;
            }
            Request.Builder builder = request.newBuilder();
            for (Map.Entry<String, String> entry : extraHeaders.entrySet()) {
                builder.addHeader(entry.getKey(), entry.getValue());
            }
            requestHolder.set(builder.build());
            requestMixin.glowroot$setExtraHeaders(null);
        }
    }

    @Advice.Pointcut(className="okhttp3.Call", methodName="enqueue", methodParameterTypes={"okhttp3.Callback"}, nestingGroup="http-client")
    public static class EnqueueAdvice {
        @Advice.OnMethodBefore
        @Nullable
        public static AsyncSpan onBefore(@Bind.This Call call, @Bind.Argument(value=0) ParameterHolder<Callback> callback, ThreadContext context) {
            Request request = call.request();
            if (request == null) {
                return null;
            }
            if (callback == null) {
                return null;
            }
            HttpUrl httpUrl = request.url();
            String url = httpUrl == null ? "" : httpUrl.toString();
            RequestMixin requestMixin = (RequestMixin)RequestMixin.class.cast(request);
            HashMap<String, String> extraHeaders = new HashMap<String, String>(4);
            requestMixin.glowroot$setExtraHeaders(extraHeaders);
            AsyncSpan span = Util.startAsyncOutgoingSpan(context, request.method(), url, SETTER, extraHeaders, TIMER_NAME);
            callback.set(OkHttp3xInstrumentation.createWrapper(callback, span, context));
            return span;
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Enter @Nullable AsyncSpan span) {
            if (span != null) {
                span.stopSyncTimer();
            }
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter @Nullable AsyncSpan span) {
            if (span != null) {
                span.stopSyncTimer();
                span.endWithError(t);
            }
        }
    }

    @Advice.Pointcut(className="okhttp3.Call", methodName="execute", methodParameterTypes={}, nestingGroup="http-client")
    public static class ExecuteAdvice {
        @Advice.OnMethodBefore
        @Nullable
        public static Span onBefore(@Bind.This Call call, ThreadContext context) {
            Request request = call.request();
            if (request == null) {
                return null;
            }
            HttpUrl httpUrl = request.url();
            String url = httpUrl == null ? "" : httpUrl.toString();
            RequestMixin requestMixin = (RequestMixin)RequestMixin.class.cast(request);
            HashMap<String, String> extraHeaders = new HashMap<String, String>(4);
            requestMixin.glowroot$setExtraHeaders(extraHeaders);
            return Util.startOutgoingSpan(context, request.method(), url, SETTER, extraHeaders, TIMER_NAME);
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Return Response response, @Bind.Enter @Nullable Span span) {
            if (span != null) {
                HttpRequestMessageSupplier supplier = (HttpRequestMessageSupplier)span.getMessageSupplier();
                if (supplier != null) {
                    supplier.setStatusCode(response.code());
                }
                span.end();
            }
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter @Nullable Span span) {
            if (span != null) {
                span.endWithError(t);
            }
        }
    }

    @Advice.Pointcut(className="okhttp3.OkHttpClient", methodName="newCall", methodParameterTypes={"okhttp3.Request"})
    public static class NewCallAdvice {
        @Advice.OnMethodBefore
        public static void onBefore(@Bind.Argument(value=0) ParameterHolder<Request> requestHolder) {
            Request request = requestHolder.get();
            if (request != null) {
                requestHolder.set(request.newBuilder().build());
            }
        }
    }

    public static interface RequestMixin {
        @Nullable
        public Map<String, String> glowroot$getExtraHeaders();

        public void glowroot$setExtraHeaders(@Nullable Map<String, String> var1);
    }

    @Mixin(value={"okhttp3.Request"})
    public static class RequestMixinImpl
    implements RequestMixin {
        @Nullable
        private volatile transient Map<String, String> glowroot$extraHeaders;

        @Override
        @Nullable
        public Map<String, String> glowroot$getExtraHeaders() {
            return this.glowroot$extraHeaders;
        }

        @Override
        public void glowroot$setExtraHeaders(@Nullable Map<String, String> extraHeaders) {
            this.glowroot$extraHeaders = extraHeaders;
        }
    }
}

