/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.okhttp.boot;

import java.lang.reflect.Field;
import org.glowroot.instrumentation.api.ClassInfo;
import org.glowroot.instrumentation.api.Logger;
import org.glowroot.instrumentation.api.checker.Nullable;
import org.glowroot.instrumentation.api.util.Reflection;

public class CallInvoker {
    private static final Logger logger = Logger.getLogger(CallInvoker.class);
    @Nullable
    private final Field originalRequestField;

    public CallInvoker(ClassInfo classInfo) {
        this.originalRequestField = CallInvoker.getRequestField(classInfo.getLoader());
    }

    @Nullable
    public Object getOriginalRequest(Object call) {
        if (this.originalRequestField == null) {
            return null;
        }
        return Reflection.getFieldValue(this.originalRequestField, call);
    }

    @Nullable
    private static Field getRequestField(@Nullable ClassLoader loader) {
        Class<?> callClass = Reflection.getClassWithWarnIfNotFound("com.squareup.okhttp.Call", loader);
        if (callClass == null) {
            return null;
        }
        try {
            Field field = callClass.getDeclaredField("originalRequest");
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            try {
                Field field = callClass.getDeclaredField("request");
                field.setAccessible(true);
                return field;
            }
            catch (Exception f) {
                logger.warn(e.getMessage(), e);
                logger.debug(f.getMessage(), f);
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), e);
        }
        return null;
    }
}

