/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.okhttp.boot;

import org.glowroot.instrumentation.api.AsyncSpan;
import org.glowroot.instrumentation.api.Setter;
import org.glowroot.instrumentation.api.Span;
import org.glowroot.instrumentation.api.ThreadContext;
import org.glowroot.instrumentation.api.TimerName;
import org.glowroot.instrumentation.api.checker.Nullable;
import org.glowroot.instrumentation.okhttp.boot.HttpRequestMessageSupplier;

public class Util {
    private Util() {
    }

    public static <C> Span startOutgoingSpan(ThreadContext context, @Nullable String httpMethod, @Nullable String uri, Setter<C> setter, C carrier, TimerName timerName) {
        return context.startOutgoingSpan("HTTP", Util.getText(httpMethod, uri), setter, carrier, new HttpRequestMessageSupplier(httpMethod, uri), timerName);
    }

    public static <C> AsyncSpan startAsyncOutgoingSpan(ThreadContext context, @Nullable String httpMethod, @Nullable String uri, Setter<C> setter, C carrier, TimerName timerName) {
        return context.startAsyncOutgoingSpan("HTTP", Util.getText(httpMethod, uri), setter, carrier, new HttpRequestMessageSupplier(httpMethod, uri), timerName);
    }

    private static String getText(@Nullable String httpMethod, @Nullable String uri) {
        int maxLength = 0;
        if (httpMethod != null) {
            maxLength += httpMethod.length();
        }
        if (uri != null) {
            maxLength += uri.length() + 1;
        }
        StringBuilder sb = new StringBuilder(maxLength);
        if (httpMethod != null) {
            sb.append(httpMethod);
        }
        if (uri != null) {
            if (sb.length() != 0) {
                sb.append(' ');
            }
            sb.append(Util.stripQueryString(uri));
        }
        return sb.toString();
    }

    private static String stripQueryString(String uri) {
        int index = uri.indexOf(63);
        return index == -1 ? uri : uri.substring(0, index);
    }
}

