/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.struts;

import org.glowroot.instrumentation.api.Agent;
import org.glowroot.instrumentation.api.MessageSupplier;
import org.glowroot.instrumentation.api.Span;
import org.glowroot.instrumentation.api.ThreadContext;
import org.glowroot.instrumentation.api.TimerName;
import org.glowroot.instrumentation.api.checker.Nullable;
import org.glowroot.instrumentation.api.weaving.Advice;
import org.glowroot.instrumentation.api.weaving.Bind;

public class Struts1xInstrumentation {
    private static final TimerName TIMER_NAME = Agent.getTimerName("struts action");

    private static String getTransactionName(@Nullable String httpMethod, Class<?> actionClass) {
        StringBuilder sb = new StringBuilder();
        if (httpMethod != null && !httpMethod.isEmpty()) {
            sb.append(httpMethod);
            sb.append(' ');
        }
        sb.append(actionClass.getSimpleName());
        sb.append("#execute");
        return sb.toString();
    }

    @Advice.Pointcut(className="org.apache.struts.action.Action", methodName="execute", methodParameterTypes={"org.apache.struts.action.ActionMapping", "org.apache.struts.action.ActionForm", ".."}, nestingGroup="struts")
    public static class ActionAdvice {
        @Advice.OnMethodBefore
        public static Span onBefore(@Bind.This Object action, ThreadContext context) {
            Class<?> actionClass = action.getClass();
            String httpMethod = null;
            ThreadContext.ServletRequestInfo servletRequestInfo = context.getServletRequestInfo();
            if (servletRequestInfo != null) {
                httpMethod = servletRequestInfo.getMethod();
            }
            context.setTransactionName(Struts1xInstrumentation.getTransactionName(httpMethod, actionClass), -100);
            return context.startLocalSpan(MessageSupplier.create("struts action: {}.execute()", actionClass.getName()), TIMER_NAME);
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Enter Span span) {
            span.end();
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter Span span) {
            span.endWithError(t);
        }
    }
}

