/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.instrumentation.struts;

import org.glowroot.instrumentation.api.Agent;
import org.glowroot.instrumentation.api.MessageSupplier;
import org.glowroot.instrumentation.api.Span;
import org.glowroot.instrumentation.api.ThreadContext;
import org.glowroot.instrumentation.api.TimerName;
import org.glowroot.instrumentation.api.checker.Nullable;
import org.glowroot.instrumentation.api.weaving.Advice;
import org.glowroot.instrumentation.api.weaving.Bind;
import org.glowroot.instrumentation.api.weaving.Shim;

public class Struts2xInstrumentation {
    private static final TimerName TIMER_NAME = Agent.getTimerName("struts action");

    private static String getTransactionName(@Nullable String httpMethod, Class<?> actionClass, String methodName) {
        StringBuilder sb = new StringBuilder();
        if (httpMethod != null && !httpMethod.isEmpty()) {
            sb.append(httpMethod);
            sb.append(' ');
        }
        sb.append(actionClass.getSimpleName());
        sb.append('#');
        sb.append(methodName);
        return sb.toString();
    }

    @Advice.Pointcut(className="com.opensymphony.xwork2.ActionProxy", methodName="execute", methodParameterTypes={}, nestingGroup="struts")
    public static class ActionProxyAdvice {
        @Advice.OnMethodBefore
        public static Span onBefore(@Bind.This ActionProxy actionProxy, ThreadContext context) {
            Class<?> actionClass = actionProxy.getAction().getClass();
            String actionMethod = actionProxy.getMethod();
            String methodName = actionMethod != null ? actionMethod : "execute";
            String httpMethod = null;
            ThreadContext.ServletRequestInfo servletRequestInfo = context.getServletRequestInfo();
            if (servletRequestInfo != null) {
                httpMethod = servletRequestInfo.getMethod();
            }
            context.setTransactionName(Struts2xInstrumentation.getTransactionName(httpMethod, actionClass, methodName), -100);
            return context.startLocalSpan(MessageSupplier.create("struts action: {}.{}()", actionClass.getName(), methodName), TIMER_NAME);
        }

        @Advice.OnMethodReturn
        public static void onReturn(@Bind.Enter Span span) {
            span.end();
        }

        @Advice.OnMethodThrow
        public static void onThrow(@Bind.Thrown Throwable t, @Bind.Enter Span span) {
            span.endWithError(t);
        }
    }

    @Shim(value={"com.opensymphony.xwork2.ActionProxy"})
    public static interface ActionProxy {
        public Object getAction();

        public String getMethod();
    }
}

