/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.common;

import com.microsoft.applicationinsights.internal.channel.TransmissionHandler;
import com.microsoft.applicationinsights.internal.channel.TransmissionHandlerArgs;
import com.microsoft.applicationinsights.internal.channel.common.TransmissionPolicyManager;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;

public class ErrorHandler
implements TransmissionHandler {
    private TransmissionPolicyManager transmissionPolicyManager;

    public ErrorHandler(TransmissionPolicyManager policy) {
        this.transmissionPolicyManager = policy;
    }

    @Override
    public void onTransmissionSent(TransmissionHandlerArgs args) {
        this.validateTransmissionAndSend(args);
    }

    boolean validateTransmissionAndSend(TransmissionHandlerArgs args) {
        if (args.getTransmission() != null && args.getTransmissionDispatcher() != null) {
            args.getTransmission().incrementNumberOfSends();
            switch (args.getResponseCode()) {
                case 0: 
                case 408: 
                case 500: 
                case 503: {
                    this.backoffAndSendTransmission(args);
                    return true;
                }
            }
            InternalLogger.INSTANCE.trace("Http response code %s not handled by %s", args.getResponseCode(), this.getClass().getName());
            return false;
        }
        if (args.getException() != null) {
            this.backoffAndSendTransmission(args);
            return true;
        }
        return false;
    }

    private void backoffAndSendTransmission(TransmissionHandlerArgs args) {
        if (args.getTransmission() != null && args.getTransmission().getNumberOfSends() > this.transmissionPolicyManager.getMaxInstantRetries()) {
            this.transmissionPolicyManager.backoff();
        }
        args.getTransmissionDispatcher().dispatch(args.getTransmission());
    }
}

