/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.telemetry;

import com.microsoft.applicationinsights.core.dependencies.google.common.base.Strings;
import com.microsoft.applicationinsights.internal.schemav2.RequestData;
import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import com.microsoft.applicationinsights.internal.util.Sanitizer;
import com.microsoft.applicationinsights.telemetry.BaseSampleSourceTelemetry;
import com.microsoft.applicationinsights.telemetry.Duration;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.concurrent.ConcurrentMap;

public final class RequestTelemetry
extends BaseSampleSourceTelemetry<RequestData> {
    private Double samplingPercentage;
    private final RequestData data = new RequestData();
    private String httpMethod;
    private boolean allowAgentToOverrideName;
    public static final String ENVELOPE_NAME = "Request";
    public static final String BASE_TYPE = "RequestData";

    public RequestTelemetry() {
        this.initialize(this.data.getProperties());
        this.setId(LocalStringsUtils.generateRandomIntegerId());
        this.setTimestamp(new Date());
        this.setResponseCode(Integer.toString(200));
        this.setSuccess(true);
    }

    public RequestTelemetry(String name, Date timestamp, long duration, String responseCode, boolean success) {
        this(name, timestamp, new Duration(duration), responseCode, success);
    }

    public RequestTelemetry(String name, Date timestamp, Duration duration, String responseCode, boolean success) {
        this.initialize(this.data.getProperties());
        this.setId(LocalStringsUtils.generateRandomIntegerId());
        this.setTimestamp(timestamp);
        this.setName(name);
        this.setDuration(duration);
        this.setResponseCode(responseCode);
        this.setSuccess(success);
    }

    @Override
    public int getVer() {
        return this.getData().getVer();
    }

    public ConcurrentMap<String, Double> getMetrics() {
        return this.data.getMeasurements();
    }

    @Override
    public void setTimestamp(Date timestamp) {
        if (timestamp == null) {
            timestamp = new Date();
        }
        super.setTimestamp(timestamp);
    }

    public String getName() {
        return this.data.getName();
    }

    public void setName(String name) {
        if (Strings.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("The event name cannot be null or empty");
        }
        this.data.setName(name);
        this.allowAgentToOverrideName = false;
    }

    public String getId() {
        return this.data.getId();
    }

    public void setId(String id) {
        this.data.setId(id);
    }

    public String getResponseCode() {
        return this.data.getResponseCode();
    }

    public void setResponseCode(String responseCode) {
        this.data.setResponseCode(responseCode);
    }

    public String getSource() {
        return this.data.getSource();
    }

    public void setSource(String value) {
        this.data.setSource(value);
    }

    public boolean isSuccess() {
        return this.data.getSuccess();
    }

    public void setSuccess(boolean success) {
        this.data.setSuccess(success);
    }

    public Duration getDuration() {
        return this.data.getDuration();
    }

    public void setDuration(Duration duration) {
        this.data.setDuration(duration);
    }

    public URL getUrl() throws MalformedURLException {
        if (LocalStringsUtils.isNullOrEmpty(this.data.getUrl())) {
            return null;
        }
        return new URL(this.data.getUrl());
    }

    public void setUrl(URL url) {
        this.data.setUrl(url.toString());
    }

    public String getUrlString() {
        return this.getData().getUrl();
    }

    public void setUrl(String url) throws MalformedURLException {
        URL u = new URL(url);
        this.data.setUrl(u.toString());
    }

    @Deprecated
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Deprecated
    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    @Override
    public Double getSamplingPercentage() {
        return this.samplingPercentage;
    }

    @Override
    public void setSamplingPercentage(Double samplingPercentage) {
        this.samplingPercentage = samplingPercentage;
    }

    @Override
    @Deprecated
    protected void additionalSanitize() {
        this.data.setName(Sanitizer.sanitizeName(this.data.getName()));
        this.data.setId(Sanitizer.sanitizeName(this.data.getId()));
        Sanitizer.sanitizeMeasurements(this.getMetrics());
        Sanitizer.sanitizeUri(this.data.getUrl());
    }

    @Override
    protected RequestData getData() {
        return this.data;
    }

    @Override
    public String getEnvelopName() {
        return ENVELOPE_NAME;
    }

    @Override
    public String getBaseTypeName() {
        return BASE_TYPE;
    }

    public boolean isAllowAgentToOverrideName() {
        return this.allowAgentToOverrideName;
    }

    public void setAllowAgentToOverrideName(boolean allowAgentToOverrideName) {
        this.allowAgentToOverrideName = allowAgentToOverrideName;
    }
}

