/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights;

import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.channel.TelemetryChannel;
import com.microsoft.applicationinsights.common.CommonUtils;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.StringUtils;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.core.dependencies.google.common.base.Strings;
import com.microsoft.applicationinsights.extensibility.ContextInitializer;
import com.microsoft.applicationinsights.extensibility.TelemetryInitializer;
import com.microsoft.applicationinsights.extensibility.TelemetryProcessor;
import com.microsoft.applicationinsights.extensibility.context.InternalContext;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.quickpulse.QuickPulseDataCollector;
import com.microsoft.applicationinsights.internal.shutdown.SDKShutdownActivity;
import com.microsoft.applicationinsights.internal.util.MapUtil;
import com.microsoft.applicationinsights.telemetry.Duration;
import com.microsoft.applicationinsights.telemetry.EventTelemetry;
import com.microsoft.applicationinsights.telemetry.ExceptionTelemetry;
import com.microsoft.applicationinsights.telemetry.MetricTelemetry;
import com.microsoft.applicationinsights.telemetry.PageViewTelemetry;
import com.microsoft.applicationinsights.telemetry.RemoteDependencyTelemetry;
import com.microsoft.applicationinsights.telemetry.RequestTelemetry;
import com.microsoft.applicationinsights.telemetry.SessionState;
import com.microsoft.applicationinsights.telemetry.SeverityLevel;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import com.microsoft.applicationinsights.telemetry.TelemetryContext;
import com.microsoft.applicationinsights.telemetry.TraceTelemetry;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class TelemetryClient {
    private final TelemetryConfiguration configuration;
    private volatile TelemetryContext context;
    private TelemetryChannel channel;
    private static final Object TELEMETRY_STOP_HOOK_LOCK = new Object();
    private static final Object TELEMETRY_CONTEXT_LOCK = new Object();
    private static AtomicLong generateCounter = new AtomicLong(0L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TelemetryClient(TelemetryConfiguration configuration) {
        if (configuration == null) {
            configuration = TelemetryConfiguration.getActive();
        }
        Object object = TELEMETRY_STOP_HOOK_LOCK;
        synchronized (object) {
            SDKShutdownActivity.INSTANCE.register(configuration.getChannel());
        }
        this.configuration = configuration;
    }

    public TelemetryClient() {
        this(TelemetryConfiguration.getActive());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TelemetryContext getContext() {
        if (this.context == null) {
            Object object = TELEMETRY_CONTEXT_LOCK;
            synchronized (object) {
                if (this.context == null) {
                    this.context = this.createInitializedContext();
                }
            }
        }
        return this.context;
    }

    public boolean isDisabled() {
        return Strings.isNullOrEmpty(this.configuration.getInstrumentationKey()) && Strings.isNullOrEmpty(this.getContext().getInstrumentationKey()) || this.configuration.isTrackingDisabled();
    }

    @Deprecated
    public void trackSessionState(SessionState sessionState) {
        this.trackEvent("Track Session State: " + sessionState.toString());
    }

    public void trackEvent(String name, Map<String, String> properties, Map<String, Double> metrics) {
        if (this.isDisabled()) {
            return;
        }
        if (Strings.isNullOrEmpty(name)) {
            name = "";
        }
        EventTelemetry et = new EventTelemetry(name);
        MapUtil.copy(properties, et.getContext().getProperties());
        MapUtil.copy(metrics, et.getMetrics());
        this.track(et);
    }

    public void trackEvent(String name) {
        this.trackEvent(name, null, null);
    }

    public void trackEvent(EventTelemetry telemetry) {
        this.track(telemetry);
    }

    public void trackTrace(String message, SeverityLevel severityLevel, Map<String, String> properties) {
        if (this.isDisabled()) {
            return;
        }
        if (Strings.isNullOrEmpty(message)) {
            message = "";
        }
        TraceTelemetry et = new TraceTelemetry(message, severityLevel);
        MapUtil.copy(properties, et.getContext().getProperties());
        this.track(et);
    }

    public void trackTrace(String message) {
        this.trackTrace(message, null, null);
    }

    public void trackTrace(String message, SeverityLevel severityLevel) {
        this.trackTrace(message, severityLevel, null);
    }

    public void trackTrace(TraceTelemetry telemetry) {
        this.track(telemetry);
    }

    @Deprecated
    public void trackMetric(String name, double value, int sampleCount, double min, double max, Map<String, String> properties) {
        this.trackMetric(name, value, sampleCount, min, max, null, properties);
    }

    public void trackMetric(String name, double value, Integer sampleCount, Double min, Double max, Double stdDev, Map<String, String> properties) {
        if (this.isDisabled()) {
            return;
        }
        MetricTelemetry mt = new MetricTelemetry(name, value);
        mt.setCount(sampleCount);
        mt.setMin(min);
        mt.setMax(max);
        mt.setStandardDeviation(stdDev);
        MapUtil.copy(properties, mt.getProperties());
        this.track(mt);
    }

    public void trackMetric(String name, double value) {
        this.trackMetric(name, value, null, null, null, null, null);
    }

    public void trackMetric(MetricTelemetry telemetry) {
        this.track(telemetry);
    }

    public void trackException(Exception exception, Map<String, String> properties, Map<String, Double> metrics) {
        if (this.isDisabled()) {
            return;
        }
        ExceptionTelemetry et = new ExceptionTelemetry(exception);
        MapUtil.copy(properties, et.getContext().getProperties());
        MapUtil.copy(metrics, et.getMetrics());
        this.track(et);
    }

    public void trackException(Exception exception) {
        this.trackException(exception, null, null);
    }

    public void trackException(ExceptionTelemetry telemetry) {
        this.track(telemetry);
    }

    public void trackHttpRequest(String name, Date timestamp, long duration, String responseCode, boolean success) {
        if (this.isDisabled()) {
            return;
        }
        this.track(new RequestTelemetry(name, timestamp, duration, responseCode, success));
    }

    public void trackRequest(RequestTelemetry request) {
        this.track(request);
    }

    public void trackDependency(String dependencyName, String commandName, Duration duration, boolean success) {
        RemoteDependencyTelemetry remoteDependencyTelemetry = new RemoteDependencyTelemetry(dependencyName, commandName, duration, success);
        this.trackDependency(remoteDependencyTelemetry);
    }

    public void trackDependency(RemoteDependencyTelemetry telemetry) {
        if (this.isDisabled()) {
            return;
        }
        if (telemetry == null) {
            telemetry = new RemoteDependencyTelemetry("");
        }
        this.track(telemetry);
    }

    public void trackPageView(String name) {
        if (this.isDisabled()) {
            return;
        }
        if (name == null) {
            name = "";
        }
        PageViewTelemetry telemetry = new PageViewTelemetry(name);
        this.track(telemetry);
    }

    public void trackPageView(PageViewTelemetry telemetry) {
        this.track(telemetry);
    }

    public void track(Telemetry telemetry) {
        TelemetryContext ctx;
        if (generateCounter.incrementAndGet() % 10000L == 0L) {
            InternalLogger.INSTANCE.info("Total events generated till now %d", generateCounter.get());
        }
        if (telemetry == null) {
            throw new IllegalArgumentException("telemetry item cannot be null");
        }
        if (this.isDisabled()) {
            return;
        }
        if (telemetry.getTimestamp() == null) {
            telemetry.setTimestamp(new Date());
        }
        if (Strings.isNullOrEmpty((ctx = this.getContext()).getInstrumentationKey())) {
            ctx.setInstrumentationKey(this.configuration.getInstrumentationKey());
        }
        try {
            telemetry.getContext().initialize(ctx);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                InternalLogger.INSTANCE.error("Exception while telemetry context's initialization: '%s'", t.toString());
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable td) {
                // empty catch block
            }
        }
        this.activateInitializers(telemetry);
        if (Strings.isNullOrEmpty(telemetry.getContext().getInstrumentationKey())) {
            throw new IllegalArgumentException("Instrumentation key cannot be undefined.");
        }
        if (!this.activateProcessors(telemetry)) {
            return;
        }
        try {
            QuickPulseDataCollector.INSTANCE.add(telemetry);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable td) {
            // empty catch block
        }
        try {
            this.getChannel().send(telemetry);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                InternalLogger.INSTANCE.error("Exception while sending telemetry: '%s'", t.toString());
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void activateInitializers(Telemetry telemetry) {
        for (TelemetryInitializer initializer : this.configuration.getTelemetryInitializers()) {
            try {
                initializer.initialize(telemetry);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable e) {
                try {
                    InternalLogger.INSTANCE.error("Failed during telemetry initialization class '%s', exception: %s", initializer.getClass().getName(), e.toString());
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable throwable) {
                }
            }
        }
    }

    private boolean activateProcessors(Telemetry telemetry) {
        for (TelemetryProcessor processor : this.configuration.getTelemetryProcessors()) {
            try {
                if (processor.process(telemetry)) continue;
                return false;
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    InternalLogger.INSTANCE.error("Exception while processing telemetry: '%s'", t.toString());
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable throwable) {
                }
            }
        }
        return true;
    }

    public void flush() {
        this.getChannel().flush();
    }

    TelemetryChannel getChannel() {
        if (this.channel == null) {
            this.channel = this.configuration.getChannel();
        }
        return this.channel;
    }

    private TelemetryContext createInitializedContext() {
        String host;
        TelemetryContext ctx = new TelemetryContext();
        ctx.setInstrumentationKey(this.configuration.getInstrumentationKey());
        String roleName = this.configuration.getRoleName();
        if (StringUtils.isNotEmpty(roleName)) {
            ctx.getCloud().setRole(roleName);
        }
        for (ContextInitializer init : this.configuration.getContextInitializers()) {
            if (init == null) {
                InternalLogger.INSTANCE.warn("Found null ContextInitializer in configuration. Skipping...", new Object[0]);
                continue;
            }
            try {
                init.initialize(ctx);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    if (!InternalLogger.INSTANCE.isErrorEnabled()) continue;
                    InternalLogger.INSTANCE.error("Exception in context initializer, %s: %s", init.getClass().getSimpleName(), ExceptionUtils.getStackTrace(t));
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable throwable) {
                }
            }
        }
        InternalContext internal = ctx.getInternal();
        if (CommonUtils.isNullOrEmpty(internal.getNodeName()) && !CommonUtils.isNullOrEmpty(host = CommonUtils.getHostName())) {
            internal.setNodeName(host);
        }
        return ctx;
    }
}

