/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.channel.concrete;

import com.microsoft.applicationinsights.TelemetryConfiguration;
import com.microsoft.applicationinsights.channel.TelemetryChannel;
import com.microsoft.applicationinsights.channel.TelemetrySampler;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.core.dependencies.google.common.annotations.VisibleForTesting;
import com.microsoft.applicationinsights.core.dependencies.google.common.base.Preconditions;
import com.microsoft.applicationinsights.core.dependencies.google.common.base.Strings;
import com.microsoft.applicationinsights.internal.channel.ConfiguredTransmitterFactory;
import com.microsoft.applicationinsights.internal.channel.TelemetriesTransmitter;
import com.microsoft.applicationinsights.internal.channel.TransmitterFactory;
import com.microsoft.applicationinsights.internal.channel.common.TelemetryBuffer;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.util.LimitsEnforcer;
import com.microsoft.applicationinsights.internal.util.Sanitizer;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public abstract class TelemetryChannelBase<T>
implements TelemetryChannel {
    public static final int DEFAULT_MAX_INSTANT_RETRY = 3;
    public static final int DEFAULT_MAX_TELEMETRY_BUFFER_CAPACITY = 500;
    public static final int DEFAULT_FLUSH_BUFFER_TIMEOUT_IN_SECONDS = 5;
    public static final int MIN_MAX_TELEMETRY_BUFFER_CAPACITY = 1;
    public static final int MAX_MAX_TELEMETRY_BUFFER_CAPACITY = 1000;
    public static final int MIN_FLUSH_BUFFER_TIMEOUT_IN_SECONDS = 1;
    public static final int MAX_FLUSH_BUFFER_TIMEOUT_IN_SECONDS = 300;
    public static final String DEVELOPER_MODE_SYSTEM_PROPRETY_NAME = "APPLICATION_INSIGHTS_DEVELOPER_MODE";
    public static final String MAX_TELEMETRY_BUFFER_CAPACITY_NAME = "MaxTelemetryBufferCapacity";
    public static final String INSTANT_RETRY_NAME = "MaxInstantRetry";
    public static final String FLUSH_BUFFER_TIMEOUT_IN_SECONDS_NAME = "FlushIntervalInSeconds";
    public static final String DEVELOPER_MODE_NAME = "DeveloperMode";
    public static final String ENDPOINT_ADDRESS_NAME = "EndpointAddress";
    public static final String MAX_TRANSMISSION_STORAGE_CAPACITY_NAME = "MaxTransmissionStorageFilesCapacityInMB";
    public static final int LOG_TELEMETRY_ITEMS_MODULUS = 10000;
    public static final String THROTTLING_ENABLED_NAME = "Throttling";
    private TransmitterFactory transmitterFactory;
    private AtomicLong itemsSent = new AtomicLong(0L);
    protected boolean stopped = false;
    protected boolean isInitailized = false;
    protected TelemetriesTransmitter<T> telemetriesTransmitter;
    protected volatile TelemetrySampler telemetrySampler;
    protected TelemetryBuffer<T> telemetryBuffer;
    private boolean developerMode = false;
    private TelemetryConfiguration configuration;

    public TelemetryChannelBase(TelemetryConfiguration configuration) {
        this.initialize(configuration, null, null, Boolean.getBoolean(DEVELOPER_MODE_SYSTEM_PROPRETY_NAME), this.createDefaultMaxTelemetryBufferCapacityEnforcer(null), this.createDefaultSendIntervalInSecondsEnforcer(null), true, 3);
    }

    public TelemetryChannelBase(TelemetryConfiguration configuration, String maxTransmissionStorageCapacity, boolean developerMode, int maxTelemetryBufferCapacity, int sendIntervalInMillis, boolean throttling, int maxInstantRetries) {
        this.initialize(configuration, null, maxTransmissionStorageCapacity, developerMode, this.createDefaultMaxTelemetryBufferCapacityEnforcer(maxTelemetryBufferCapacity), this.createDefaultSendIntervalInSecondsEnforcer(sendIntervalInMillis), throttling, maxInstantRetries);
    }

    @Deprecated
    public TelemetryChannelBase() {
        this.initialize(null, null, null, Boolean.getBoolean(DEVELOPER_MODE_SYSTEM_PROPRETY_NAME), this.createDefaultMaxTelemetryBufferCapacityEnforcer(null), this.createDefaultSendIntervalInSecondsEnforcer(null), true, 3);
    }

    @Deprecated
    public TelemetryChannelBase(String endpointAddress, boolean developerMode, int maxTelemetryBufferCapacity, int sendIntervalInMillis) {
        this(endpointAddress, null, developerMode, maxTelemetryBufferCapacity, sendIntervalInMillis, true, 3);
    }

    @Deprecated
    public TelemetryChannelBase(String endpointAddress, String maxTransmissionStorageCapacity, boolean developerMode, int maxTelemetryBufferCapacity, int sendIntervalInMillis, boolean throttling, int maxInstantRetries) {
        this.initialize(null, endpointAddress, maxTransmissionStorageCapacity, developerMode, this.createDefaultMaxTelemetryBufferCapacityEnforcer(maxTelemetryBufferCapacity), this.createDefaultSendIntervalInSecondsEnforcer(sendIntervalInMillis), throttling, maxInstantRetries);
    }

    @Deprecated
    public TelemetryChannelBase(Map<String, String> namesAndValues) {
        this(null, namesAndValues);
    }

    public TelemetryChannelBase(TelemetryConfiguration configuration, Map<String, String> namesAndValues) {
        boolean developerMode = false;
        String endpointAddress = null;
        int maxInstantRetries = 3;
        LimitsEnforcer maxTelemetryBufferCapacityEnforcer = this.createDefaultMaxTelemetryBufferCapacityEnforcer(null);
        LimitsEnforcer sendIntervalInSecondsEnforcer = this.createDefaultSendIntervalInSecondsEnforcer(null);
        boolean throttling = true;
        String maxTransmissionStorageCapacity = null;
        if (namesAndValues != null) {
            throttling = Boolean.parseBoolean(namesAndValues.get(THROTTLING_ENABLED_NAME));
            developerMode = Boolean.parseBoolean(namesAndValues.get(DEVELOPER_MODE_NAME));
            try {
                String instantRetryValue = namesAndValues.get(INSTANT_RETRY_NAME);
                if (instantRetryValue != null) {
                    maxInstantRetries = Integer.parseInt(instantRetryValue);
                }
            }
            catch (NumberFormatException e) {
                InternalLogger.INSTANCE.error("Unable to parse configuration setting %s to integer value.%nStack Trace:%n%s", INSTANT_RETRY_NAME, ExceptionUtils.getStackTrace(e));
            }
            if (!developerMode) {
                developerMode = Boolean.parseBoolean(System.getProperty(DEVELOPER_MODE_SYSTEM_PROPRETY_NAME));
            }
            endpointAddress = namesAndValues.get(ENDPOINT_ADDRESS_NAME);
            maxTelemetryBufferCapacityEnforcer.normalizeStringValue(namesAndValues.get(MAX_TELEMETRY_BUFFER_CAPACITY_NAME));
            sendIntervalInSecondsEnforcer.normalizeStringValue(namesAndValues.get(FLUSH_BUFFER_TIMEOUT_IN_SECONDS_NAME));
            maxTransmissionStorageCapacity = namesAndValues.get(MAX_TRANSMISSION_STORAGE_CAPACITY_NAME);
        }
        this.initialize(configuration, endpointAddress, maxTransmissionStorageCapacity, developerMode, maxTelemetryBufferCapacityEnforcer, sendIntervalInSecondsEnforcer, throttling, maxInstantRetries);
    }

    @Deprecated
    protected synchronized void initialize(String endpointAddress, String maxTransmissionStorageCapacity, boolean developerMode, LimitsEnforcer maxTelemetryBufferCapacityEnforcer, LimitsEnforcer sendIntervalInSeconds, boolean throttling, int maxInstantRetry) {
        this.initialize(null, endpointAddress, maxTransmissionStorageCapacity, developerMode, maxTelemetryBufferCapacityEnforcer, sendIntervalInSeconds, throttling, maxInstantRetry);
    }

    protected synchronized void initialize(TelemetryConfiguration configuration, String endpointAddress, String maxTransmissionStorageCapacity, boolean developerMode, LimitsEnforcer maxTelemetryBufferCapacityEnforcer, LimitsEnforcer sendIntervalInSeconds, boolean throttling, int maxInstantRetry) {
        if (this.isInitailized) {
            return;
        }
        this.makeSureEndpointAddressIsValid(endpointAddress);
        this.configuration = configuration;
        TransmitterFactory<T> transmitterFactory = this.getTransmitterFactory();
        this.telemetriesTransmitter = transmitterFactory instanceof ConfiguredTransmitterFactory && endpointAddress == null ? ((ConfiguredTransmitterFactory)transmitterFactory).create(configuration, maxTransmissionStorageCapacity, throttling, maxInstantRetry) : transmitterFactory.create(endpointAddress, maxTransmissionStorageCapacity, throttling, maxInstantRetry);
        this.telemetryBuffer = new TelemetryBuffer<T>(this.telemetriesTransmitter, maxTelemetryBufferCapacityEnforcer, sendIntervalInSeconds);
        this.setDeveloperMode(developerMode);
        this.isInitailized = true;
    }

    protected synchronized TransmitterFactory<T> getTransmitterFactory() {
        if (this.transmitterFactory == null) {
            this.transmitterFactory = this.createTransmitterFactory();
        }
        return this.transmitterFactory;
    }

    @VisibleForTesting
    TelemetryConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean isDeveloperMode() {
        return this.developerMode;
    }

    @Override
    public void setDeveloperMode(boolean developerMode) {
        if (developerMode != this.developerMode) {
            this.developerMode = developerMode;
            int maxTelemetriesInBatch = this.developerMode ? 1 : 500;
            this.setMaxTelemetriesInBatch(maxTelemetriesInBatch);
        }
    }

    @Override
    public synchronized void stop(long timeout, TimeUnit timeUnit) {
        try {
            if (this.stopped) {
                return;
            }
            this.telemetriesTransmitter.stop(timeout, timeUnit);
            this.stopped = true;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                InternalLogger.INSTANCE.error("Exception generated while stopping telemetry transmitter", new Object[0]);
                InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(t));
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setTransmitBufferTimeoutInSeconds(int transmitBufferTimeoutInSeconds) {
        this.telemetryBuffer.setTransmitBufferTimeoutInSeconds(transmitBufferTimeoutInSeconds);
    }

    public void setMaxTelemetriesInBatch(int maxTelemetriesInBatch) {
        this.telemetryBuffer.setMaxTelemetriesInBatch(maxTelemetriesInBatch);
    }

    @Override
    public void flush() {
        this.telemetryBuffer.flush();
    }

    @Override
    public void setSampler(TelemetrySampler telemetrySampler) {
        if (this.telemetrySampler == null) {
            this.telemetrySampler = telemetrySampler;
        }
    }

    @Override
    public void send(Telemetry telemetry) {
        Preconditions.checkNotNull(telemetry, "Telemetry item must be non null");
        if (this.isDeveloperMode()) {
            telemetry.getContext().getProperties().put(DEVELOPER_MODE_NAME, "true");
        }
        if (this.telemetrySampler != null && !this.telemetrySampler.isSampledIn(telemetry)) {
            return;
        }
        if (!this.doSend(telemetry)) {
            return;
        }
        if (this.itemsSent.incrementAndGet() % 10000L == 0L) {
            InternalLogger.INSTANCE.info("items sent till now %d", this.itemsSent.get());
        }
        if (this.isDeveloperMode()) {
            this.writeTelemetryToDebugOutput(telemetry);
        }
    }

    protected abstract boolean doSend(Telemetry var1);

    private void writeTelemetryToDebugOutput(Telemetry telemetry) {
        InternalLogger.INSTANCE.trace("%s sending telemetry: %s", this.getClass().getSimpleName(), telemetry.toString());
    }

    protected abstract TransmitterFactory<T> createTransmitterFactory();

    protected LimitsEnforcer createDefaultMaxTelemetryBufferCapacityEnforcer(Integer currentValue) {
        return LimitsEnforcer.createWithClosestLimitOnError(MAX_TELEMETRY_BUFFER_CAPACITY_NAME, 1, 1000, 500, currentValue);
    }

    protected LimitsEnforcer createDefaultSendIntervalInSecondsEnforcer(Integer currentValue) {
        return LimitsEnforcer.createWithClosestLimitOnError(FLUSH_BUFFER_TIMEOUT_IN_SECONDS_NAME, 1, 300, 5, currentValue);
    }

    protected void makeSureEndpointAddressIsValid(String endpointAddress) {
        if (Strings.isNullOrEmpty(endpointAddress)) {
            return;
        }
        URI uri = Sanitizer.sanitizeUri(endpointAddress);
        if (uri == null) {
            String errorMessage = String.format("Endpoint address %s is not a valid uri", endpointAddress);
            InternalLogger.INSTANCE.error(errorMessage, new Object[0]);
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

