/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.agent;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.agent.internal.sdk.SdkBridge;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.telemetry.Duration;
import com.microsoft.applicationinsights.telemetry.ExceptionTelemetry;
import com.microsoft.applicationinsights.telemetry.RemoteDependencyTelemetry;
import com.microsoft.applicationinsights.telemetry.SeverityLevel;
import com.microsoft.applicationinsights.telemetry.TraceTelemetry;
import java.util.Date;

public abstract class AbstractSdkBridge<T>
implements SdkBridge<T> {
    private final TelemetryClient client;

    public AbstractSdkBridge(TelemetryClient client) {
        this.client = client;
    }

    public void track(SdkBridge.RemoteDependencyTelemetry agentTelemetry) {
        String resultCode;
        String target;
        String commandName;
        String name;
        RemoteDependencyTelemetry telemetry = new RemoteDependencyTelemetry();
        telemetry.setTimestamp(new Date(agentTelemetry.getTimestamp()));
        telemetry.setDuration(new Duration(agentTelemetry.getDurationMillis()));
        telemetry.setType(agentTelemetry.getType());
        telemetry.setSuccess(agentTelemetry.isSuccess());
        String id = agentTelemetry.getId();
        if (id != null) {
            telemetry.setId(id);
        }
        if ((name = agentTelemetry.getName()) != null) {
            telemetry.setName(name);
        }
        if ((commandName = agentTelemetry.getCommandName()) != null) {
            telemetry.setCommandName(commandName);
        }
        if ((target = agentTelemetry.getTarget()) != null) {
            telemetry.setTarget(target);
        }
        if ((resultCode = agentTelemetry.getResultCode()) != null) {
            telemetry.setResultCode(resultCode);
        }
        telemetry.getProperties().putAll(agentTelemetry.getProperties());
        this.client.track(telemetry);
    }

    public void track(SdkBridge.TraceTelemetry agentTelemetry) {
        TraceTelemetry telemetry = new TraceTelemetry();
        telemetry.setMessage(agentTelemetry.getMessage());
        String level = agentTelemetry.getLevel();
        if (level != null) {
            telemetry.setSeverityLevel(AbstractSdkBridge.toSeverityLevel(level));
        }
        telemetry.getProperties().putAll(agentTelemetry.getProperties());
        this.client.track(telemetry);
    }

    public void track(SdkBridge.ExceptionTelemetry agentTelemetry) {
        ExceptionTelemetry telemetry = new ExceptionTelemetry();
        telemetry.setException(agentTelemetry.getThrowable());
        String level = agentTelemetry.getLevel();
        if (level != null) {
            telemetry.setSeverityLevel(AbstractSdkBridge.toSeverityLevel(level));
        }
        telemetry.getProperties().putAll(agentTelemetry.getProperties());
        this.client.track(telemetry);
    }

    private static SeverityLevel toSeverityLevel(String level) {
        switch (level) {
            case "FATAL": {
                return SeverityLevel.Critical;
            }
            case "ERROR": {
                return SeverityLevel.Error;
            }
            case "WARN": {
                return SeverityLevel.Warning;
            }
            case "INFO": {
                return SeverityLevel.Information;
            }
            case "DEBUG": 
            case "TRACE": 
            case "ALL": {
                return SeverityLevel.Verbose;
            }
        }
        InternalLogger.INSTANCE.error("Unexpected level '%s', using TRACE level as default", level);
        return SeverityLevel.Verbose;
    }
}

