/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.shutdown;

import com.microsoft.applicationinsights.channel.TelemetryChannel;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.shutdown.Stoppable;
import com.microsoft.applicationinsights.internal.util.ChannelFetcher;
import com.microsoft.applicationinsights.internal.util.ThreadPoolUtils;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public enum SDKShutdownActivity {
    INSTANCE;

    private static volatile SDKShutdownAction shutdownAction;

    public void register(TelemetryChannel channel) {
        this.getShutdownAction().register(channel);
    }

    public void register(ChannelFetcher fetcher) {
        this.getShutdownAction().register(fetcher);
    }

    public void register(Stoppable stoppable) {
        this.getShutdownAction().register(stoppable);
    }

    public void register(Closeable closable) {
        this.getShutdownAction().register(closable);
    }

    public void register(ExecutorService service) {
        this.getShutdownAction().register(service);
    }

    public void stopAll() {
        this.getShutdownAction().run();
        InternalLogger.INSTANCE.info("SDK shutdown complete.", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SDKShutdownAction getShutdownAction() {
        if (shutdownAction == null) {
            SDKShutdownActivity sDKShutdownActivity = INSTANCE;
            synchronized (sDKShutdownActivity) {
                block7: {
                    if (shutdownAction == null) {
                        try {
                            SDKShutdownAction action = new SDKShutdownAction();
                            Thread t = new Thread((Runnable)action, SDKShutdownActivity.class.getSimpleName() + "-ShutdownHook");
                            Runtime.getRuntime().addShutdownHook(t);
                            shutdownAction = action;
                        }
                        catch (Exception e) {
                            if (!InternalLogger.INSTANCE.isErrorEnabled()) break block7;
                            InternalLogger.INSTANCE.error("Error while adding shutdown hook in getShutDownThread call: %s", ExceptionUtils.getStackTrace(e));
                        }
                    }
                }
            }
        }
        return shutdownAction;
    }

    private static class SDKShutdownAction
    implements Runnable {
        private boolean stopped = false;
        private final Map<TelemetryChannel, Boolean> channels = new HashMap<TelemetryChannel, Boolean>();
        @Deprecated
        private final List<ChannelFetcher> fetchers = new ArrayList<ChannelFetcher>();
        private final List<Stoppable> stoppables = new ArrayList<Stoppable>();
        private final List<Closeable> closeables = new ArrayList<Closeable>();
        private volatile long perThreadTimeout = 10L;
        private volatile TimeUnit perThreadTimeUnit = TimeUnit.SECONDS;

        private SDKShutdownAction() {
        }

        public synchronized void register(TelemetryChannel channel) {
            this.channels.put(channel, true);
        }

        public synchronized void register(ChannelFetcher fetcher) {
            this.fetchers.add(fetcher);
        }

        public synchronized void register(Stoppable stoppable) {
            this.stoppables.add(stoppable);
        }

        public synchronized void register(Closeable closeable) {
            this.closeables.add(closeable);
        }

        public synchronized void register(final ExecutorService service) {
            this.register(new Stoppable(){

                @Override
                public void stop(long timeout, TimeUnit timeUnit) {
                    ThreadPoolUtils.stop(service, timeout, timeUnit);
                }
            });
        }

        public long getPerThreadTimeout() {
            return this.perThreadTimeout;
        }

        public TimeUnit getPerThreadTimeUnit() {
            return this.perThreadTimeUnit;
        }

        public void setPerThreadTimeout(long timeout, TimeUnit unit) {
            this.perThreadTimeout = timeout;
            this.perThreadTimeUnit = unit;
        }

        @Override
        public synchronized void run() {
            if (this.stopped) {
                return;
            }
            InternalLogger.INSTANCE.info("Shutting down Applciation Insights", new Object[0]);
            try {
                this.stopChannels();
                this.stopStoppables();
                this.closeClosables();
            }
            finally {
                this.stopInternalLogger();
            }
            this.stopped = true;
        }

        private void stopInternalLogger() {
            try {
                InternalLogger.INSTANCE.stop();
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private void stopChannels() {
            for (TelemetryChannel channel : this.channels.keySet()) {
                this.stopChannel(channel);
            }
            for (ChannelFetcher fetcher : this.fetchers) {
                this.stopChannel(fetcher.fetch());
            }
        }

        private void stopChannel(TelemetryChannel channelToStop) {
            try {
                if (channelToStop != null) {
                    channelToStop.stop(this.getPerThreadTimeout(), this.getPerThreadTimeUnit());
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    if (InternalLogger.INSTANCE.isErrorEnabled()) {
                        InternalLogger.INSTANCE.error("Failed to stop channel: '%s'", ExceptionUtils.getStackTrace(t));
                    }
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        private void stopStoppables() {
            for (Stoppable stoppable : this.stoppables) {
                try {
                    stoppable.stop(this.getPerThreadTimeout(), this.getPerThreadTimeUnit());
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    try {
                        InternalLogger.INSTANCE.error("Failed to stop stoppable class '%s': '%s'", stoppable.getClass().getName(), t.toString());
                        InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(t));
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable throwable) {
                    }
                }
            }
        }

        private void closeClosables() {
            for (Closeable c : this.closeables) {
                try {
                    c.close();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    try {
                        InternalLogger.INSTANCE.error("Failed to close closeable class '%s': %s", c.getClass().getName(), t.toString());
                        InternalLogger.INSTANCE.trace("Stack trace: %s", ExceptionUtils.getStackTrace(t));
                    }
                    catch (ThreadDeath td2) {
                        throw td2;
                    }
                    catch (Throwable throwable) {
                    }
                }
            }
        }
    }
}

