/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.autoconfigure;

import com.microsoft.applicationinsights.autoconfigure.ApplicationInsightsProperties;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.web.extensibility.initializers.WebOperationIdTelemetryInitializer;
import com.microsoft.applicationinsights.web.extensibility.initializers.WebOperationNameTelemetryInitializer;
import com.microsoft.applicationinsights.web.extensibility.initializers.WebSessionTelemetryInitializer;
import com.microsoft.applicationinsights.web.extensibility.initializers.WebUserAgentTelemetryInitializer;
import com.microsoft.applicationinsights.web.extensibility.initializers.WebUserTelemetryInitializer;
import com.microsoft.applicationinsights.web.extensibility.modules.WebRequestTrackingTelemetryModule;
import com.microsoft.applicationinsights.web.extensibility.modules.WebSessionTrackingTelemetryModule;
import com.microsoft.applicationinsights.web.extensibility.modules.WebUserTrackingTelemetryModule;
import com.microsoft.applicationinsights.web.internal.perfcounter.WebPerformanceCounterModule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"azure.application-insights.web.enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnWebApplication
class ApplicationInsightsWebModuleConfiguration {
    private ApplicationInsightsProperties applicationInsightsProperties;

    @Autowired
    public ApplicationInsightsWebModuleConfiguration(ApplicationInsightsProperties properties) {
        this.applicationInsightsProperties = properties;
    }

    @Bean
    @ConditionalOnProperty(value={"azure.application-insights.default-modules.WebRequestTrackingTelemetryModule.enabled"}, havingValue="true", matchIfMissing=true)
    WebRequestTrackingTelemetryModule webRequestTrackingTelemetryModule() {
        WebRequestTrackingTelemetryModule w = new WebRequestTrackingTelemetryModule();
        w.isW3CEnabled = this.applicationInsightsProperties.getWeb().isEnableW3C();
        InternalLogger.INSTANCE.trace(String.format("Inbound W3C tracing is enabled %s", w.isW3CEnabled), new Object[0]);
        w.setEnableBackCompatibilityForW3C(this.applicationInsightsProperties.getWeb().isEnableW3CBackcompatMode());
        return w;
    }

    @Bean
    @ConditionalOnProperty(value={"azure.application-insights.default-modules.WebSessionTrackingTelemetryModule.enabled"}, havingValue="true", matchIfMissing=true)
    WebSessionTrackingTelemetryModule webSessionTrackingTelemetryModule() {
        return new WebSessionTrackingTelemetryModule();
    }

    @Bean
    @ConditionalOnProperty(value={"azure.application-insights.default-modules.WebUserTrackingTelemetryModule.enabled"}, havingValue="true", matchIfMissing=true)
    WebUserTrackingTelemetryModule webUserTrackingTelemetryModule() {
        return new WebUserTrackingTelemetryModule();
    }

    @Bean
    @ConditionalOnProperty(value={"azure.application-insights.default-modules.WebPerformanceCounterModule.enabled"}, havingValue="true", matchIfMissing=true)
    WebPerformanceCounterModule webPerformanceCounterModule() {
        return new WebPerformanceCounterModule();
    }

    @Bean
    @ConditionalOnProperty(value={"azure.application-insights.default-modules.WebOperationIdTelemetryInitializer.enabled"}, havingValue="true", matchIfMissing=true)
    WebOperationIdTelemetryInitializer webOperationIdTelemetryInitializer() {
        return new WebOperationIdTelemetryInitializer();
    }

    @Bean
    @ConditionalOnProperty(value={"azure.application-insights.default-modules.WebOperationNameTelemetryInitializer.enabled"}, havingValue="true", matchIfMissing=true)
    WebOperationNameTelemetryInitializer webOperationNameTelemetryInitializer() {
        return new WebOperationNameTelemetryInitializer();
    }

    @Bean
    @ConditionalOnProperty(value={"azure.application-insights.default-modules.WebSessionTelemetryInitializer.enabled"}, havingValue="true", matchIfMissing=true)
    WebSessionTelemetryInitializer webSessionTelemetryInitializer() {
        return new WebSessionTelemetryInitializer();
    }

    @Bean
    @ConditionalOnProperty(value={"azure.application-insights.default-modules.WebUserTelemetryInitializer.enabled"}, havingValue="true", matchIfMissing=true)
    WebUserTelemetryInitializer webUserTelemetryInitializer() {
        return new WebUserTelemetryInitializer();
    }

    @Bean
    @ConditionalOnProperty(value={"azure.application-insights.default-modules.WebUserAgentTelemetryInitializer.enabled"}, havingValue="true", matchIfMissing=true)
    WebUserAgentTelemetryInitializer webUserAgentTelemetryInitializer() {
        return new WebUserAgentTelemetryInitializer();
    }
}

