/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.common;

import com.microsoft.applicationinsights.core.dependencies.google.common.base.Preconditions;
import com.microsoft.applicationinsights.internal.channel.TransmissionHandler;
import com.microsoft.applicationinsights.internal.channel.TransmissionHandlerArgs;
import com.microsoft.applicationinsights.internal.channel.TransmissionHandlerObserver;
import com.microsoft.applicationinsights.internal.channel.common.ExponentialBackOffTimesPolicy;
import com.microsoft.applicationinsights.internal.channel.common.SenderThreadsBackOffManager;
import com.microsoft.applicationinsights.internal.channel.common.TransmissionPolicy;
import com.microsoft.applicationinsights.internal.channel.common.TransmissionPolicyState;
import com.microsoft.applicationinsights.internal.channel.common.TransmissionPolicyStateFetcher;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.shutdown.SDKShutdownActivity;
import com.microsoft.applicationinsights.internal.shutdown.Stoppable;
import com.microsoft.applicationinsights.internal.util.ThreadPoolUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class TransmissionPolicyManager
implements Stoppable,
TransmissionHandlerObserver {
    private static final AtomicInteger INSTANCE_ID_POOL = new AtomicInteger(1);
    private int instantRetryAmount = 3;
    private final int INSTANT_RETRY_MAX = 10;
    private SenderThreadsBackOffManager backoffManager;
    private List<TransmissionHandler> transmissionHandlers;
    private Date suspensionDate = null;
    private AtomicLong generation = new AtomicLong(0L);
    private ScheduledThreadPoolExecutor threads;
    private final TransmissionPolicyState policyState = new TransmissionPolicyState();
    private boolean throttlingIsEnabled = true;
    private final int instanceId = INSTANCE_ID_POOL.getAndIncrement();

    public TransmissionPolicyManager(boolean throttlingIsEnabled) {
        this.throttlingIsEnabled = throttlingIsEnabled;
        this.transmissionHandlers = new ArrayList<TransmissionHandler>();
        this.backoffManager = new SenderThreadsBackOffManager(new ExponentialBackOffTimesPolicy());
    }

    public void backoff() {
        this.policyState.setCurrentState(TransmissionPolicy.BACKOFF);
        long backOffMillis = this.backoffManager.backOffCurrentSenderThreadValue();
        if (backOffMillis > 0L) {
            long backOffSeconds = backOffMillis / 1000L;
            InternalLogger.INSTANCE.info("App is throttled, telemetry will be blocked for %s seconds.", backOffSeconds);
            this.suspendInSeconds(TransmissionPolicy.BACKOFF, backOffSeconds);
        }
    }

    public void clearBackoff() {
        if (this.policyState.setCurrentState(TransmissionPolicy.UNBLOCKED)) {
            InternalLogger.INSTANCE.trace("Backoff has been reset.", new Object[0]);
        }
        this.backoffManager.onDoneSending();
    }

    public void suspendInSeconds(TransmissionPolicy policy, long suspendInSeconds) {
        if (!this.throttlingIsEnabled) {
            return;
        }
        Preconditions.checkArgument(suspendInSeconds > 0L, "Suspension must be greater than zero");
        this.createScheduler();
        this.doSuspend(policy, suspendInSeconds);
    }

    @Override
    public synchronized void stop(long timeout, TimeUnit timeUnit) {
        ThreadPoolUtils.stop(this.threads, timeout, timeUnit);
        this.backoffManager.remove();
    }

    public TransmissionPolicyStateFetcher getTransmissionPolicyState() {
        return this.policyState;
    }

    private synchronized void doSuspend(TransmissionPolicy policy, long suspendInSeconds) {
        try {
            long diff;
            if (policy == TransmissionPolicy.UNBLOCKED) {
                return;
            }
            Date date = Calendar.getInstance().getTime();
            date.setTime(date.getTime() + 1000L * suspendInSeconds);
            if (this.suspensionDate != null && (diff = date.getTime() - this.suspensionDate.getTime()) <= 0L) {
                return;
            }
            long currentGeneration = this.generation.incrementAndGet();
            this.threads.schedule(new UnSuspender(currentGeneration), suspendInSeconds, TimeUnit.SECONDS);
            this.policyState.setCurrentState(policy);
            this.suspensionDate = date;
            InternalLogger.INSTANCE.info("App is throttled, telemetries are blocked from now, for %s seconds", suspendInSeconds);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                InternalLogger.INSTANCE.logAlways(InternalLogger.LoggingLevel.ERROR, "App is throttled but failed to block transmission exception: %s", t.toString());
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private synchronized void cancelSuspension(long expectedGeneration) {
        if (expectedGeneration != this.generation.get()) {
            return;
        }
        this.policyState.setCurrentState(TransmissionPolicy.UNBLOCKED);
        this.suspensionDate = null;
        InternalLogger.INSTANCE.info("App throttling is cancelled.", new Object[0]);
    }

    private synchronized void createScheduler() {
        if (this.threads != null) {
            return;
        }
        this.threads = new ScheduledThreadPoolExecutor(1);
        this.threads.setThreadFactory(ThreadPoolUtils.createDaemonThreadFactory(TransmissionPolicyManager.class, this.instanceId));
        SDKShutdownActivity.INSTANCE.register(this);
    }

    @Override
    public void onTransmissionSent(TransmissionHandlerArgs transmissionArgs) {
        for (TransmissionHandler handler : this.transmissionHandlers) {
            handler.onTransmissionSent(transmissionArgs);
        }
    }

    @Override
    public void addTransmissionHandler(TransmissionHandler handler) {
        if (handler != null) {
            this.transmissionHandlers.add(handler);
        }
    }

    public void setMaxInstantRetries(int maxInstantRetries) {
        if (maxInstantRetries > 0 && maxInstantRetries < 10) {
            this.instantRetryAmount = maxInstantRetries;
        }
    }

    public int getMaxInstantRetries() {
        return this.instantRetryAmount;
    }

    private class UnSuspender
    implements Runnable {
        private final long expectedGeneration;

        private UnSuspender(long expectedGeneration) {
            this.expectedGeneration = expectedGeneration;
        }

        @Override
        public void run() {
            try {
                TransmissionPolicyManager.this.cancelSuspension(this.expectedGeneration);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

