/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.common;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.core.dependencies.google.common.base.Optional;
import com.microsoft.applicationinsights.core.dependencies.google.common.base.Preconditions;
import com.microsoft.applicationinsights.internal.channel.TelemetriesTransmitter;
import com.microsoft.applicationinsights.internal.channel.TelemetrySerializer;
import com.microsoft.applicationinsights.internal.channel.TransmissionDispatcher;
import com.microsoft.applicationinsights.internal.channel.TransmissionsLoader;
import com.microsoft.applicationinsights.internal.channel.common.Transmission;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.util.ThreadPoolUtils;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class TransmitterImpl
implements TelemetriesTransmitter<String> {
    private static final int MAX_PENDING_SCHEDULE_REQUESTS = 16384;
    private static final AtomicInteger INSTANCE_ID_POOL = new AtomicInteger(1);
    private final TransmissionDispatcher transmissionDispatcher;
    private final TelemetrySerializer serializer;
    private final ScheduledExecutorService threadPool;
    private final TransmissionsLoader transmissionsLoader;
    private final Semaphore semaphore;
    private final int instanceId = INSTANCE_ID_POOL.getAndIncrement();

    public TransmitterImpl(TransmissionDispatcher transmissionDispatcher, TelemetrySerializer serializer, TransmissionsLoader transmissionsLoader) {
        Preconditions.checkNotNull(transmissionDispatcher, "transmissionDispatcher must be non-null value");
        Preconditions.checkNotNull(serializer, "serializer must be non-null value");
        Preconditions.checkNotNull(transmissionsLoader, "transmissionsLoader must be non-null value");
        this.transmissionDispatcher = transmissionDispatcher;
        this.serializer = serializer;
        this.semaphore = new Semaphore(16384);
        this.threadPool = Executors.newScheduledThreadPool(2, ThreadPoolUtils.createDaemonThreadFactory(TransmitterImpl.class, this.instanceId));
        this.transmissionsLoader = transmissionsLoader;
        this.transmissionsLoader.load(false);
    }

    @Override
    public boolean scheduleSend(TelemetriesTransmitter.TelemetriesFetcher telemetriesFetcher, long value, TimeUnit timeUnit) {
        Preconditions.checkNotNull(telemetriesFetcher, "telemetriesFetcher should be non-null value");
        if (!this.semaphore.tryAcquire()) {
            return false;
        }
        try {
            final ScheduledSendHandler command = new ScheduledSendHandler(this.transmissionDispatcher, telemetriesFetcher, this.serializer);
            this.threadPool.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        TransmitterImpl.this.semaphore.release();
                        command.run();
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {
                        try {
                            InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(t));
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable throwable) {
                        }
                    }
                }
            }, value, timeUnit);
            return true;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.semaphore.release();
                InternalLogger.INSTANCE.error("Error in scheduledSend of telemetry items failed. %d items were not sent ", telemetriesFetcher.fetch().size());
                InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(t));
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return true;
        }
    }

    @Override
    public boolean sendNow(Collection<String> telemetries) {
        Preconditions.checkNotNull(telemetries, "telemetries should be non-null value");
        if (!this.semaphore.tryAcquire()) {
            return false;
        }
        final SendNowHandler command = new SendNowHandler(this.transmissionDispatcher, this.serializer, telemetries);
        try {
            this.threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        TransmitterImpl.this.semaphore.release();
                        command.run();
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {
                        try {
                            InternalLogger.INSTANCE.error("exception in runnable sendNow()", new Object[0]);
                            InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(t));
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable throwable) {
                        }
                    }
                }
            });
            return true;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.semaphore.release();
                InternalLogger.INSTANCE.error("Error in scheduledSend of telemetry items failed. %d items were not sent ", telemetries.size());
                InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(t));
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }
    }

    @Override
    public void stop(long timeout, TimeUnit timeUnit) {
        this.transmissionsLoader.stop(timeout, timeUnit);
        ThreadPoolUtils.stop(this.threadPool, timeout, timeUnit);
        this.transmissionDispatcher.stop(timeout, timeUnit);
    }

    private static final class SendNowHandler
    extends SendHandler
    implements Runnable {
        private final Collection<String> telemetries;

        public SendNowHandler(TransmissionDispatcher transmissionDispatcher, TelemetrySerializer serializer, Collection<String> telemetries) {
            super(transmissionDispatcher, serializer);
            Preconditions.checkNotNull(telemetries, "telemetries should be non-null value");
            this.telemetries = telemetries;
        }

        @Override
        public void run() {
            this.dispatch(this.telemetries);
        }
    }

    private static final class ScheduledSendHandler
    extends SendHandler
    implements Runnable {
        private final TelemetriesTransmitter.TelemetriesFetcher<String> telemetriesFetcher;

        public ScheduledSendHandler(TransmissionDispatcher transmissionDispatcher, TelemetriesTransmitter.TelemetriesFetcher<String> telemetriesFetcher, TelemetrySerializer serializer) {
            super(transmissionDispatcher, serializer);
            Preconditions.checkNotNull(telemetriesFetcher, "telemetriesFetcher should be a non-null value");
            this.telemetriesFetcher = telemetriesFetcher;
        }

        @Override
        public void run() {
            Collection<String> telemetriesToSend = this.telemetriesFetcher.fetch();
            this.dispatch(telemetriesToSend);
        }
    }

    private static abstract class SendHandler {
        protected final TransmissionDispatcher transmissionDispatcher;
        protected final TelemetrySerializer serializer;

        protected SendHandler(TransmissionDispatcher transmissionDispatcher, TelemetrySerializer serializer) {
            Preconditions.checkNotNull(transmissionDispatcher, "transmissionDispatcher should be a non-null value");
            Preconditions.checkNotNull(serializer, "serializer should be a non-null value");
            this.transmissionDispatcher = transmissionDispatcher;
            this.serializer = serializer;
        }

        protected void dispatch(Collection<String> telemetries) {
            if (telemetries.isEmpty()) {
                return;
            }
            Optional<Transmission> transmission = this.serializer.serialize(telemetries);
            if (!transmission.isPresent()) {
                return;
            }
            this.transmissionDispatcher.dispatch(transmission.get());
        }
    }
}

