/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.config;

import com.microsoft.applicationinsights.core.dependencies.google.common.base.Strings;
import com.microsoft.applicationinsights.core.dependencies.xstream.annotations.XStreamAlias;
import com.microsoft.applicationinsights.core.dependencies.xstream.annotations.XStreamAsAttribute;
import java.util.HashMap;
import java.util.Map;

public class ChannelXmlElement {
    @XStreamAlias(value="EndpointAddress")
    private String endpointAddress;
    @XStreamAlias(value="MaxTelemetryBufferCapacity")
    private String maxTelemetryBufferCapacity;
    @XStreamAlias(value="FlushIntervalInSeconds")
    private String flushIntervalInSeconds;
    @XStreamAlias(value="DeveloperMode")
    private boolean developerMode;
    @XStreamAlias(value="Throttling")
    private boolean throttling = true;
    @XStreamAlias(value="MaxTransmissionStorageFilesCapacityInMB")
    private String maxTransmissionStorageFilesCapacityInMB;
    @XStreamAlias(value="MaxInstantRetry")
    private String maxInstantRetry;
    @XStreamAsAttribute
    private String type = "com.microsoft.applicationinsights.channel.concrete.inprocess.InProcessTelemetryChannel";

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Deprecated
    public String getEndpointAddress() {
        return this.endpointAddress;
    }

    public void setThrottling(boolean throttling) {
        this.throttling = throttling;
    }

    public boolean getThrottling() {
        return this.throttling;
    }

    @Deprecated
    public void setEndpointAddress(String endpointAddress) {
        this.endpointAddress = endpointAddress;
    }

    public boolean getDeveloperMode() {
        return this.developerMode;
    }

    public void setDeveloperMode(boolean developerMode) {
        this.developerMode = developerMode;
    }

    public String getMaxTelemetryBufferCapacity() {
        return this.maxTelemetryBufferCapacity;
    }

    public void setMaxTelemetryBufferCapacity(String maxTelemetryBufferCapacity) {
        this.maxTelemetryBufferCapacity = maxTelemetryBufferCapacity;
    }

    public String getFlushIntervalInSeconds() {
        return this.flushIntervalInSeconds;
    }

    public void setFlushIntervalInSeconds(String flushIntervalInSeconds) {
        this.flushIntervalInSeconds = flushIntervalInSeconds;
    }

    @Deprecated
    public String isMaxTransmissionStorageFilesCapacityInMB() {
        return this.maxTransmissionStorageFilesCapacityInMB;
    }

    public String getMaxTransmissionStorageFilesCapacityInMB() {
        return this.maxTransmissionStorageFilesCapacityInMB;
    }

    public void setMaxTransmissionStorageFilesCapacityInMB(String maxTransmissionStorageFilesCapacityInMB) {
        this.maxTransmissionStorageFilesCapacityInMB = maxTransmissionStorageFilesCapacityInMB;
    }

    public String getMaxInstantRetry() {
        return this.maxInstantRetry;
    }

    public void setMaxInstantRetry(String maxInstantRetry) {
        this.maxInstantRetry = maxInstantRetry;
    }

    public Map<String, String> getData() {
        HashMap<String, String> data = new HashMap<String, String>();
        if (this.developerMode) {
            data.put("DeveloperMode", "true");
        }
        if (!Strings.isNullOrEmpty(this.endpointAddress)) {
            data.put("EndpointAddress", this.endpointAddress);
        }
        if (!Strings.isNullOrEmpty(this.maxTelemetryBufferCapacity)) {
            data.put("MaxTelemetryBufferCapacity", this.maxTelemetryBufferCapacity);
        }
        if (!Strings.isNullOrEmpty(this.flushIntervalInSeconds)) {
            data.put("FlushIntervalInSeconds", this.flushIntervalInSeconds);
        }
        if (!Strings.isNullOrEmpty(this.maxTransmissionStorageFilesCapacityInMB)) {
            data.put("MaxTransmissionStorageFilesCapacityInMB", this.maxTransmissionStorageFilesCapacityInMB);
        }
        if (!Strings.isNullOrEmpty(this.maxInstantRetry)) {
            data.put("MaxInstantRetry", this.maxInstantRetry);
        }
        data.put("Throttling", this.throttling ? "true" : "false");
        return data;
    }
}

