/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.heartbeat;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.internal.heartbeat.HeartBeatPayloadProviderInterface;
import com.microsoft.applicationinsights.internal.heartbeat.HeartBeatProviderInterface;
import com.microsoft.applicationinsights.internal.heartbeat.MiscUtils;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.util.PropertyHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;

public class DefaultHeartBeatPropertyProvider
implements HeartBeatPayloadProviderInterface {
    private final Set<String> defaultFields = new HashSet<String>();
    private static UUID uniqueProcessId;
    private static final String name = "Default";
    private static final String JRE_VERSION = "jreVersion";
    private static final String SDK_VERSION = "sdkVersion";
    private static final String OS_VERSION = "osVersion";
    private static final String PROCESS_SESSION_ID = "processSessionId";

    public DefaultHeartBeatPropertyProvider() {
        this.initializeDefaultFields(this.defaultFields);
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean isKeyword(String keyword) {
        return this.defaultFields.contains(keyword);
    }

    @Override
    public Callable<Boolean> setDefaultPayload(final List<String> disableFields, final HeartBeatProviderInterface provider) {
        return new Callable<Boolean>(){
            Set<String> enabledProperties;
            {
                this.enabledProperties = MiscUtils.except(DefaultHeartBeatPropertyProvider.this.defaultFields, disableFields);
            }

            @Override
            public Boolean call() {
                boolean hasSetValues = false;
                for (String fieldName : this.enabledProperties) {
                    try {
                        switch (fieldName) {
                            case "jreVersion": {
                                provider.addHeartBeatProperty(fieldName, DefaultHeartBeatPropertyProvider.this.getJreVersion(), true);
                                hasSetValues = true;
                                break;
                            }
                            case "sdkVersion": {
                                provider.addHeartBeatProperty(fieldName, DefaultHeartBeatPropertyProvider.this.getSdkVersion(), true);
                                hasSetValues = true;
                                break;
                            }
                            case "osVersion": {
                                provider.addHeartBeatProperty(fieldName, DefaultHeartBeatPropertyProvider.this.getOsVersion(), true);
                                hasSetValues = true;
                                break;
                            }
                            case "processSessionId": {
                                provider.addHeartBeatProperty(fieldName, DefaultHeartBeatPropertyProvider.this.getProcessSessionId(), true);
                                hasSetValues = true;
                                break;
                            }
                            default: {
                                InternalLogger.INSTANCE.trace("Encountered unknown default property", new Object[0]);
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!InternalLogger.INSTANCE.isWarnEnabled()) continue;
                        InternalLogger.INSTANCE.warn("Failed to obtain heartbeat property: %s", ExceptionUtils.getStackTrace(e));
                    }
                }
                return hasSetValues;
            }
        };
    }

    private void initializeDefaultFields(Set<String> defaultFields) {
        defaultFields.add(JRE_VERSION);
        defaultFields.add(SDK_VERSION);
        defaultFields.add(OS_VERSION);
        defaultFields.add(PROCESS_SESSION_ID);
    }

    private String getJreVersion() {
        return System.getProperty("java.version");
    }

    private String getSdkVersion() {
        return PropertyHelper.getQualifiedSdkVersionString();
    }

    private String getOsVersion() {
        return System.getProperty("os.name");
    }

    private String getProcessSessionId() {
        if (uniqueProcessId == null) {
            uniqueProcessId = UUID.randomUUID();
        }
        return uniqueProcessId.toString();
    }
}

