/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.logger;

import com.microsoft.applicationinsights.internal.logger.LogFileProxy;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;

public final class DefaultLogFileProxy
implements LogFileProxy {
    private static String NEW_LINE = System.getProperty("line.separator");
    private static final String LOG_FILE_PREFIX = "-JavaSDKLog";
    private static final String LOG_FILE_SUFFIX = ".jsl";
    private static final int SIZE_OF_MB = 0x100000;
    private FileWriter out;
    private File file;
    private int maxSizePerFileInMB;

    public static DefaultLogFileProxy createNew(File baseFolder, String uniquePrefix, int maxSizePerFileInMB) throws IOException {
        return new DefaultLogFileProxy(baseFolder, uniquePrefix, maxSizePerFileInMB);
    }

    public static DefaultLogFileProxy attachToExistingFile(File file, int maxSizePerFileInMB) throws IOException {
        return new DefaultLogFileProxy(file, maxSizePerFileInMB);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    @Override
    public void delete() {
        try {
            Files.delete(this.file.toPath());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public void writeLine(String line) throws IOException {
        this.out.write(line + NEW_LINE);
        this.flush();
    }

    @Override
    public boolean isFull() {
        long fileSizeInMB = this.file.length() / 0x100000L;
        return (long)this.maxSizePerFileInMB < fileSizeInMB;
    }

    @Override
    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private DefaultLogFileProxy(File baseFolder, String uniquePrefix, int maxSizePerFileInMB) throws IOException {
        this.initialize(File.createTempFile(uniquePrefix + LOG_FILE_PREFIX, LOG_FILE_SUFFIX, baseFolder), maxSizePerFileInMB);
    }

    private DefaultLogFileProxy(File file, int maxSizePerFileInMB) throws IOException {
        this.initialize(file, maxSizePerFileInMB);
    }

    private void initialize(File file, int maxSizePerFileInMB) throws IOException {
        this.maxSizePerFileInMB = maxSizePerFileInMB;
        this.file = file;
        this.out = new FileWriter(file);
    }
}

