/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.perfcounter.jvm;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.perfcounter.PerformanceCounter;
import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import com.microsoft.applicationinsights.telemetry.MetricTelemetry;
import com.microsoft.applicationinsights.telemetry.TraceTelemetry;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;

public final class DeadLockDetectorPerformanceCounter
implements PerformanceCounter {
    public static final String NAME = "ThreadDeadLockDetector";
    private static final String INDENT = "    ";
    private static final String SEPERATOR = " | ";
    private static final String METRIC_NAME = "Suspected Deadlocked Threads";
    private static final int MAX_STACK_TRACE = 3;
    private final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();

    public boolean isSupported() {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        return threadBean.isSynchronizerUsageSupported();
    }

    @Override
    public String getId() {
        return "DeadLockDetector";
    }

    @Override
    public void report(TelemetryClient telemetryClient) {
        MetricTelemetry mt = new MetricTelemetry(METRIC_NAME, 0.0);
        mt.markAsCustomPerfCounter();
        long[] threadIds = this.threadBean.findDeadlockedThreads();
        if (threadIds != null && threadIds.length > 0) {
            ArrayList<Long> blockedThreads = new ArrayList<Long>();
            StringBuilder sb = new StringBuilder();
            for (long threadId : threadIds) {
                ThreadInfo threadInfo = this.threadBean.getThreadInfo(threadId);
                if (threadInfo == null) continue;
                this.setThreadInfoAndStack(sb, threadInfo);
                blockedThreads.add(threadId);
            }
            if (!blockedThreads.isEmpty()) {
                String uuid = LocalStringsUtils.generateRandomIntegerId();
                mt.setValue(blockedThreads.size());
                mt.getContext().getOperation().setId(uuid);
                TraceTelemetry trace = new TraceTelemetry(String.format("%s%s", "Suspected deadlocked threads: ", sb.toString()));
                trace.getContext().getOperation().setId(uuid);
                telemetryClient.track(trace);
            }
        }
        telemetryClient.track(mt);
    }

    private void setThreadInfoAndStack(StringBuilder sb, ThreadInfo ti) {
        try {
            this.setThreadInfo(sb, ti);
            StackTraceElement[] stacktrace = ti.getStackTrace();
            MonitorInfo[] monitors = ti.getLockedMonitors();
            int maxTraceToReport = Math.min(3, stacktrace.length);
            for (int i = 0; i < maxTraceToReport; ++i) {
                StackTraceElement ste = stacktrace[i];
                sb.append("    at " + ste.toString());
                for (MonitorInfo mi : monitors) {
                    if (mi.getLockedStackDepth() != i) continue;
                    sb.append("      - is locked " + mi);
                }
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                InternalLogger.INSTANCE.error("Error while setting the Thread Info", new Object[0]);
                InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(t));
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        sb.append(SEPERATOR);
    }

    private void setThreadInfo(StringBuilder sb, ThreadInfo ti) {
        sb.append(ti.getThreadName());
        sb.append(" Id=");
        sb.append(ti.getThreadId());
        sb.append(" is in ");
        sb.append((Object)ti.getThreadState());
        if (ti.getLockName() != null) {
            sb.append(" on lock=" + ti.getLockName());
        }
        if (ti.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (ti.isInNative()) {
            sb.append(" (running in native)");
        }
        if (ti.getLockOwnerName() != null) {
            sb.append("     is owned by " + ti.getLockOwnerName() + " Id=" + ti.getLockOwnerId());
        }
    }
}

