/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.web.dependencies.http.client.protocol;

import com.microsoft.applicationinsights.web.dependencies.http.HttpEntity;
import com.microsoft.applicationinsights.web.dependencies.http.HttpEntityEnclosingRequest;
import com.microsoft.applicationinsights.web.dependencies.http.HttpException;
import com.microsoft.applicationinsights.web.dependencies.http.HttpRequest;
import com.microsoft.applicationinsights.web.dependencies.http.HttpRequestInterceptor;
import com.microsoft.applicationinsights.web.dependencies.http.HttpVersion;
import com.microsoft.applicationinsights.web.dependencies.http.ProtocolVersion;
import com.microsoft.applicationinsights.web.dependencies.http.annotation.Contract;
import com.microsoft.applicationinsights.web.dependencies.http.annotation.ThreadingBehavior;
import com.microsoft.applicationinsights.web.dependencies.http.client.config.RequestConfig;
import com.microsoft.applicationinsights.web.dependencies.http.client.protocol.HttpClientContext;
import com.microsoft.applicationinsights.web.dependencies.http.protocol.HttpContext;
import com.microsoft.applicationinsights.web.dependencies.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

