/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.auth;

import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.UserInfo;

public class AzureCredential {
    private String accessTokenType;
    private String idToken;
    private UserInfo userInfo;
    private String accessToken;
    private String refreshToken;
    private boolean isMultipleResourceRefreshToken;
    private String defaultSubscription;
    private String environment;

    public static AzureCredential fromAuthenticationResult(AuthenticationResult result) {
        if (result == null) {
            throw new IllegalArgumentException("Parameter \"result\" cannot be null");
        }
        AzureCredential token = new AzureCredential();
        token.setAccessTokenType(result.getAccessTokenType());
        token.setAccessToken(result.getAccessToken());
        token.setRefreshToken(result.getRefreshToken());
        token.setIdToken(result.getIdToken());
        token.setUserInfo(result.getUserInfo());
        token.setMultipleResourceRefreshToken(result.isMultipleResourceRefreshToken());
        return token;
    }

    public String getAccessTokenType() {
        return this.accessTokenType;
    }

    public void setAccessTokenType(String accessTokenType) {
        this.accessTokenType = accessTokenType;
    }

    public String getIdToken() {
        return this.idToken;
    }

    public void setIdToken(String idToken) {
        this.idToken = idToken;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public boolean isMultipleResourceRefreshToken() {
        return this.isMultipleResourceRefreshToken;
    }

    public void setMultipleResourceRefreshToken(boolean isMultipleResourceRefreshToken) {
        this.isMultipleResourceRefreshToken = isMultipleResourceRefreshToken;
    }

    private AzureCredential() {
    }

    public String getDefaultSubscription() {
        return this.defaultSubscription;
    }

    public void setDefaultSubscription(String defaultSubscription) {
        this.defaultSubscription = defaultSubscription;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }
}

