/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.auth;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.auth.AzureAuthHelper;
import com.microsoft.azure.auth.Constants;
import com.microsoft.azure.auth.configuration.AuthConfiguration;
import com.microsoft.azure.auth.exception.InvalidConfigurationException;
import com.microsoft.azure.credentials.ApplicationTokenCredentials;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

class AzureServicePrincipleAuthHelper {
    private static final String AZURE_CLI_GET_SUBSCRIPTION_FAIL = "Failed to get default subscription of Azure CLI, please login Azure CLI first.";
    private static final String AZURE_CLI_LOAD_TOKEN_FAIL = "Failed to load Azure CLI token file, please login Azure CLI first.";

    static AzureTokenCredentials getAzureServicePrincipleCredentials(AuthConfiguration config) throws InvalidConfigurationException, IOException {
        if (StringUtils.isBlank((CharSequence)config.getClient())) {
            throw new IllegalArgumentException("'Client Id' of your service principal is not configured.");
        }
        if (StringUtils.isBlank((CharSequence)config.getTenant())) {
            throw new IllegalArgumentException("'Tenant Id' of your service principal is not configured.");
        }
        AzureEnvironment env = AzureAuthHelper.getAzureEnvironment(config.getEnvironment());
        if (StringUtils.isNotBlank((CharSequence)config.getCertificate())) {
            return new ApplicationTokenCredentials(config.getClient(), config.getTenant(), FileUtils.readFileToByteArray((File)new File(config.getCertificate())), config.getCertificatePassword(), env);
        }
        if (StringUtils.isNotBlank((CharSequence)config.getKey())) {
            return new ApplicationTokenCredentials(config.getClient(), config.getTenant(), config.getKey(), env);
        }
        throw new InvalidConfigurationException("Invalid auth configuration, either 'key' or 'certificate' is required.");
    }

    static AzureTokenCredentials getCredentialFromAzureCliWithServicePrincipal() throws InvalidConfigurationException, IOException {
        String servicePrincipalName;
        JsonObject subscription = AzureServicePrincipleAuthHelper.getDefaultSubscriptionObject();
        String string = servicePrincipalName = subscription == null ? null : subscription.get("user").getAsJsonObject().get("name").getAsString();
        if (servicePrincipalName == null) {
            throw new InvalidConfigurationException(AZURE_CLI_GET_SUBSCRIPTION_FAIL);
        }
        JsonArray tokens = AzureServicePrincipleAuthHelper.getAzureCliTokenList();
        if (tokens == null) {
            throw new InvalidConfigurationException(AZURE_CLI_LOAD_TOKEN_FAIL);
        }
        for (JsonElement token : tokens) {
            JsonObject tokenObject = (JsonObject)token;
            if (!servicePrincipalName.equals(AzureServicePrincipleAuthHelper.getStringFromJsonObject(tokenObject, "servicePrincipalId"))) continue;
            String tenantId = AzureServicePrincipleAuthHelper.getStringFromJsonObject(tokenObject, "servicePrincipalTenant");
            String key = AzureServicePrincipleAuthHelper.getStringFromJsonObject(tokenObject, "accessToken");
            String certificateFile = AzureServicePrincipleAuthHelper.getStringFromJsonObject(tokenObject, "certificateFile");
            String env = AzureServicePrincipleAuthHelper.getStringFromJsonObject(subscription, "environmentName");
            String subscriptionId = AzureServicePrincipleAuthHelper.getStringFromJsonObject(subscription, "id");
            if (StringUtils.isNotBlank((CharSequence)key)) {
                return new ApplicationTokenCredentials(servicePrincipalName, tenantId, key, AzureAuthHelper.getAzureEnvironment(env)).withDefaultSubscriptionId(subscriptionId);
            }
            if (!StringUtils.isNotBlank((CharSequence)certificateFile) || !new File(certificateFile).exists()) continue;
            return new ApplicationTokenCredentials(servicePrincipalName, tenantId, FileUtils.readFileToByteArray((File)new File(certificateFile)), null, AzureAuthHelper.getAzureEnvironment(env)).withDefaultSubscriptionId(subscriptionId);
        }
        return null;
    }

    static JsonObject getDefaultSubscriptionObject() throws IOException {
        File azureProfile = new File(AzureAuthHelper.getAzureConfigFolder(), "azureProfile.json");
        String profileJsonContent = FileUtils.readFileToString((File)azureProfile, (Charset)Constants.UTF8);
        JsonArray subscriptionList = ((JsonObject)new Gson().fromJson(profileJsonContent, JsonObject.class)).getAsJsonArray("subscriptions");
        for (JsonElement child : subscriptionList) {
            JsonObject subscription = (JsonObject)child;
            if (!subscription.getAsJsonPrimitive("isDefault").getAsBoolean()) continue;
            return subscription;
        }
        return null;
    }

    static JsonArray getAzureCliTokenList() throws IOException {
        File azureTokenFile = new File(AzureAuthHelper.getAzureConfigFolder(), "accessTokens.json");
        String tokenJsonContent = FileUtils.readFileToString((File)azureTokenFile, (Charset)Constants.UTF8);
        return (JsonArray)new Gson().fromJson(tokenJsonContent, JsonArray.class);
    }

    private static String getStringFromJsonObject(JsonObject obj, String property) {
        if (obj == null || property == null || !obj.has(property)) {
            return null;
        }
        return obj.get(property).getAsString();
    }

    private AzureServicePrincipleAuthHelper() {
    }
}

