/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.auth;

import com.microsoft.aad.adal4j.AdalErrorCode;
import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationException;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.DeviceCode;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.auth.AzureContextExecutor;
import com.microsoft.azure.auth.AzureCredential;
import com.microsoft.azure.auth.LocalAuthServer;
import com.microsoft.azure.auth.exception.AzureLoginFailureException;
import com.microsoft.azure.auth.exception.AzureLoginTimeoutException;
import com.microsoft.azure.common.utils.TextUtils;
import com.microsoft.azure.tools.exception.DesktopNotSupportedException;
import java.awt.Desktop;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AzureLoginHelper {
    private static final Map<AzureEnvironment, String> AZURE_ENVIRONMENT_MAP = new HashMap<AzureEnvironment, String>();

    static AzureCredential oAuthLogin(AzureEnvironment env) throws AzureLoginFailureException, ExecutionException, DesktopNotSupportedException, InterruptedException {
        if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            throw new DesktopNotSupportedException("Not able to launch a browser to log you in.");
        }
        LocalAuthServer server = new LocalAuthServer();
        try {
            String code;
            server.start();
            URI redirectUri = server.getURI();
            String redirectUrl = redirectUri.toString();
            try {
                String authorizationUrl = AzureLoginHelper.authorizationUrl(env, redirectUrl);
                Desktop.getDesktop().browse(new URL(authorizationUrl).toURI());
                code = server.waitForCode();
            }
            catch (InterruptedException e) {
                throw new AzureLoginFailureException("The OAuth flow is interrupted.");
            }
            finally {
                server.stop();
            }
            AzureCredential cred = new AzureContextExecutor(AzureLoginHelper.baseURL(env), context -> (AuthenticationResult)context.acquireTokenByAuthorizationCode(code, env.managementEndpoint(), "04b07795-8ddb-461a-bbee-02f9e1bf7b46", redirectUri, null).get()).execute();
            cred.setEnvironment(AzureLoginHelper.getShortNameForAzureEnvironment(env));
            return cred;
        }
        catch (IOException | URISyntaxException e) {
            throw new AzureLoginFailureException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AzureCredential deviceLogin(AzureEnvironment env) throws AzureLoginFailureException, MalformedURLException, InterruptedException, ExecutionException {
        AzureCredential azureCredential;
        String currentLogLevelFieldName = "currentLogLevel";
        Logger logger = null;
        Object oldLevelValue = null;
        try {
            try {
                logger = LoggerFactory.getLogger(AuthenticationContext.class);
                if (logger != null) {
                    oldLevelValue = FieldUtils.readField((Object)logger, (String)"currentLogLevel", (boolean)true);
                    FieldUtils.writeField((Object)logger, (String)"currentLogLevel", (Object)41, (boolean)true);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                System.out.println("Failed to disable the log of AuthenticationContext, it will continue being noisy.");
            }
            AzureCredential cred = new AzureContextExecutor(AzureLoginHelper.baseURL(env), authenticationContext -> {
                DeviceCode deviceCode = (DeviceCode)authenticationContext.acquireDeviceCode("04b07795-8ddb-461a-bbee-02f9e1bf7b46", env.managementEndpoint(), null).get();
                System.out.println(TextUtils.yellow((String)deviceCode.getMessage()));
                long remaining = deviceCode.getExpiresIn();
                long interval = deviceCode.getInterval();
                while (remaining > 0L) {
                    try {
                        remaining -= interval;
                        Thread.sleep(Duration.ofSeconds(interval).toMillis());
                        return (AuthenticationResult)authenticationContext.acquireTokenByDeviceCode(deviceCode, null).get();
                    }
                    catch (ExecutionException e) {
                        if (e.getCause() instanceof AuthenticationException && ((AuthenticationException)e.getCause()).getErrorCode() == AdalErrorCode.AUTHORIZATION_PENDING) continue;
                        System.out.println(e.getMessage());
                        break;
                    }
                }
                throw new AzureLoginTimeoutException(String.format("Cannot proceed with device login after waiting for %d minutes.", deviceCode.getExpiresIn() / 60L));
            }).execute();
            cred.setEnvironment(AzureLoginHelper.getShortNameForAzureEnvironment(env));
            azureCredential = cred;
        }
        catch (Throwable throwable) {
            try {
                if (logger != null) {
                    FieldUtils.writeField((Object)logger, (String)"currentLogLevel", oldLevelValue, (boolean)true);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                System.out.println("Failed to reset the log level of AuthenticationContext.");
            }
            throw throwable;
        }
        try {
            if (logger != null) {
                FieldUtils.writeField((Object)logger, (String)"currentLogLevel", (Object)oldLevelValue, (boolean)true);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            System.out.println("Failed to reset the log level of AuthenticationContext.");
        }
        return azureCredential;
    }

    static AzureCredential refreshToken(AzureEnvironment env, String refreshToken) throws MalformedURLException, InterruptedException, ExecutionException {
        if (env == null) {
            throw new IllegalArgumentException("Parameter 'env' cannot be null.");
        }
        if (StringUtils.isBlank((CharSequence)refreshToken)) {
            throw new IllegalArgumentException("Parameter 'refreshToken' cannot be empty.");
        }
        try {
            return new AzureContextExecutor(AzureLoginHelper.baseURL(env), authenticationContext -> (AuthenticationResult)authenticationContext.acquireTokenByRefreshToken(refreshToken, "04b07795-8ddb-461a-bbee-02f9e1bf7b46", env.managementEndpoint(), null).get()).execute();
        }
        catch (AzureLoginTimeoutException e) {
            return null;
        }
    }

    static String getShortNameForAzureEnvironment(AzureEnvironment env) {
        return AZURE_ENVIRONMENT_MAP.get(env);
    }

    static String authorizationUrl(AzureEnvironment env, String redirectUrl) throws URISyntaxException, MalformedURLException {
        if (env == null) {
            throw new IllegalArgumentException("Parameter 'env' cannot be null.");
        }
        if (StringUtils.isBlank((CharSequence)redirectUrl)) {
            throw new IllegalArgumentException("Parameter 'redirectUrl' cannot be empty.");
        }
        URIBuilder builder = new URIBuilder(AzureLoginHelper.baseURL(env));
        builder.setPath(String.format("%s/oauth2/authorize", builder.getPath())).setParameter("client_id", "04b07795-8ddb-461a-bbee-02f9e1bf7b46").setParameter("response_type", "code").setParameter("redirect_uri", redirectUrl).setParameter("prompt", "select_account").setParameter("resource", env.managementEndpoint());
        return builder.build().toURL().toString();
    }

    static String baseURL(AzureEnvironment env) {
        return env.activeDirectoryEndpoint() + "common";
    }

    private AzureLoginHelper() {
    }

    static {
        Object[] knownEnvironments = AzureEnvironment.knownEnvironments();
        for (Field field : AzureEnvironment.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                Object obj = FieldUtils.readStaticField((Field)field);
                if (!ArrayUtils.contains((Object[])knownEnvironments, (Object)obj)) continue;
                AZURE_ENVIRONMENT_MAP.put((AzureEnvironment)obj, field.getName().toLowerCase());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }
}

