/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventgrid.customization;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.eventgrid.customization.SystemEventTypeMappings;
import com.microsoft.azure.eventgrid.models.EventGridEvent;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import com.microsoft.rest.protocol.SerializerAdapter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@Beta
public class EventGridSubscriber {
    private final AzureJacksonAdapter defaultSerializerAdapter = new AzureJacksonAdapter();
    private Map<String, Type> eventTypeToEventDataMapping = new HashMap<String, Type>();

    @Beta
    public EventGridSubscriber() {
    }

    @Beta
    public void putCustomEventMapping(String eventType, Type eventDataType) {
        if (eventType == null || eventType.isEmpty()) {
            throw new IllegalArgumentException("eventType parameter is required and cannot be null or empty");
        }
        if (eventDataType == null) {
            throw new IllegalArgumentException("eventDataType parameter is required and cannot be null");
        }
        this.eventTypeToEventDataMapping.put(EventGridSubscriber.canonicalizeEventType(eventType), eventDataType);
    }

    @Beta
    public Type getCustomEventMapping(String eventType) {
        if (!this.containsCustomEventMappingFor(eventType)) {
            return null;
        }
        return this.eventTypeToEventDataMapping.get(EventGridSubscriber.canonicalizeEventType(eventType));
    }

    @Beta
    public Set<Map.Entry<String, Type>> getAllCustomEventMappings() {
        return Collections.unmodifiableSet(this.eventTypeToEventDataMapping.entrySet());
    }

    @Beta
    public boolean removeCustomEventMapping(String eventType) {
        if (!this.containsCustomEventMappingFor(eventType)) {
            return false;
        }
        this.eventTypeToEventDataMapping.remove(EventGridSubscriber.canonicalizeEventType(eventType));
        return true;
    }

    @Beta
    public boolean containsCustomEventMappingFor(String eventType) {
        if (eventType == null || eventType.isEmpty()) {
            return false;
        }
        return this.eventTypeToEventDataMapping.containsKey(EventGridSubscriber.canonicalizeEventType(eventType));
    }

    @Beta
    public EventGridEvent[] deserializeEventGridEvents(String requestContent) throws IOException {
        return this.deserializeEventGridEvents(requestContent, (SerializerAdapter<ObjectMapper>)this.defaultSerializerAdapter);
    }

    @Beta
    public EventGridEvent[] deserializeEventGridEvents(String requestContent, SerializerAdapter<ObjectMapper> serializerAdapter) throws IOException {
        EventGridEvent[] eventGridEvents;
        for (EventGridEvent receivedEvent : eventGridEvents = (EventGridEvent[])serializerAdapter.deserialize(requestContent, EventGridEvent[].class)) {
            String eventType;
            Type eventDataType;
            if (receivedEvent.data() == null || (eventDataType = SystemEventTypeMappings.containsMappingFor(eventType = receivedEvent.eventType()) ? SystemEventTypeMappings.getMapping(eventType) : (this.containsCustomEventMappingFor(eventType) ? this.getCustomEventMapping(eventType) : null)) == null) continue;
            String eventDataAsString = serializerAdapter.serializeRaw(receivedEvent.data());
            Object eventData = serializerAdapter.deserialize(eventDataAsString, eventDataType);
            EventGridSubscriber.setEventData(receivedEvent, eventData);
        }
        return eventGridEvents;
    }

    private static void setEventData(EventGridEvent event, Object data) {
        try {
            Field dataField = event.getClass().getDeclaredField("data");
            dataField.setAccessible(true);
            dataField.set(event, data);
        }
        catch (NoSuchFieldException nsfe) {
            throw new RuntimeException(nsfe);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    private static String canonicalizeEventType(String eventType) {
        if (eventType == null) {
            return null;
        }
        return eventType.toLowerCase();
    }
}

