/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs;

import com.microsoft.azure.servicebus.amqp.AmqpConstants;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;

public class EventData
implements Serializable {
    private static final long serialVersionUID = -5631628195600014255L;
    private transient Binary bodyData;
    private String partitionKey;
    private String offset;
    private long sequenceNumber;
    private Instant enqueuedTime;
    private boolean isReceivedEvent;
    private Map<String, String> properties;
    private SystemProperties systemProperties;

    private EventData() {
    }

    EventData(Message amqpMessage) {
        if (amqpMessage == null) {
            throw new IllegalArgumentException("amqpMessage cannot be null");
        }
        Map messageAnnotations = amqpMessage.getMessageAnnotations().getValue();
        Object partitionKeyObj = messageAnnotations.get(AmqpConstants.PARTITION_KEY);
        if (partitionKeyObj != null) {
            this.partitionKey = partitionKeyObj.toString();
            messageAnnotations.remove(AmqpConstants.PARTITION_KEY);
        }
        Object sequenceNumberObj = messageAnnotations.get(AmqpConstants.SEQUENCE_NUMBER);
        this.sequenceNumber = (Long)sequenceNumberObj;
        messageAnnotations.remove(AmqpConstants.SEQUENCE_NUMBER);
        Object enqueuedTimeUtcObj = messageAnnotations.get(AmqpConstants.ENQUEUED_TIME_UTC);
        this.enqueuedTime = ((Date)enqueuedTimeUtcObj).toInstant();
        messageAnnotations.remove(AmqpConstants.ENQUEUED_TIME_UTC);
        this.offset = messageAnnotations.get(AmqpConstants.OFFSET).toString();
        messageAnnotations.remove(AmqpConstants.OFFSET);
        Map<String, String> map = this.properties = amqpMessage.getApplicationProperties() == null ? null : amqpMessage.getApplicationProperties().getValue();
        if (!messageAnnotations.isEmpty()) {
            if (this.properties == null) {
                this.properties = new HashMap<String, String>();
            }
            for (Map.Entry annotation : messageAnnotations.entrySet()) {
                this.properties.put(((Symbol)annotation.getKey()).toString(), annotation.getValue() != null ? annotation.getValue().toString() : null);
            }
        }
        this.bodyData = amqpMessage.getBody() == null ? null : ((Data)amqpMessage.getBody()).getValue();
        this.isReceivedEvent = true;
        amqpMessage.clear();
    }

    public EventData(byte[] data) {
        this();
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        this.bodyData = new Binary(data);
    }

    public EventData(byte[] data, int offset, int length) {
        this();
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        this.bodyData = new Binary(data, offset, length);
    }

    public EventData(ByteBuffer buffer) {
        this();
        if (buffer == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        this.bodyData = Binary.create((ByteBuffer)buffer);
    }

    public byte[] getBody() {
        return this.bodyData == null ? null : this.bodyData.getArray();
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> applicationProperties) {
        this.properties = applicationProperties;
    }

    public SystemProperties getSystemProperties() {
        if (this.isReceivedEvent && this.systemProperties == null) {
            this.systemProperties = new SystemProperties(this);
        }
        return this.systemProperties;
    }

    Message toAmqpMessage() {
        Message amqpMessage = Proton.message();
        if (this.properties != null && !this.properties.isEmpty()) {
            ApplicationProperties applicationProperties = new ApplicationProperties(this.properties);
            amqpMessage.setApplicationProperties(applicationProperties);
        }
        if (this.bodyData != null) {
            amqpMessage.setBody((Section)new Data(this.bodyData));
        }
        return amqpMessage;
    }

    Message toAmqpMessage(String partitionKey) {
        Message amqpMessage = this.toAmqpMessage();
        MessageAnnotations messageAnnotations = amqpMessage.getMessageAnnotations() == null ? new MessageAnnotations(new HashMap()) : amqpMessage.getMessageAnnotations();
        messageAnnotations.getValue().put(AmqpConstants.PARTITION_KEY, partitionKey);
        amqpMessage.setMessageAnnotations(messageAnnotations);
        return amqpMessage;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.bodyData.getLength());
        out.write(this.bodyData.getArray(), this.bodyData.getArrayOffset(), this.bodyData.getLength());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int length = in.readInt();
        byte[] data = new byte[length];
        in.read(data, 0, length);
        this.bodyData = new Binary(data, 0, length);
    }

    public static class SystemProperties
    implements Serializable {
        private static final long serialVersionUID = -2827050124966993723L;
        private final EventData eventData;

        protected SystemProperties() {
            this.eventData = null;
        }

        private SystemProperties(EventData eventData) {
            this.eventData = eventData;
        }

        public long getSequenceNumber() {
            return this.eventData.sequenceNumber;
        }

        public Instant getEnqueuedTime() {
            return this.eventData.enqueuedTime;
        }

        public String getOffset() {
            return this.eventData.offset;
        }

        public String getPartitionKey() {
            return this.eventData.partitionKey;
        }
    }
}

