/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus;

import com.microsoft.azure.servicebus.IllegalConnectionStringFormatException;
import com.microsoft.azure.servicebus.MessagingFactory;
import com.microsoft.azure.servicebus.RetryPolicy;
import com.microsoft.azure.servicebus.StringUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConnectionStringBuilder {
    static final String endpointFormat = "amqps://%s.servicebus.windows.net";
    static final String endpointRawFormat = "amqps://%s";
    static final String HostnameConfigName = "Hostname";
    static final String EndpointConfigName = "Endpoint";
    static final String SharedAccessKeyNameConfigName = "SharedAccessKeyName";
    static final String SharedAccessKeyConfigName = "SharedAccessKey";
    static final String EntityPathConfigName = "EntityPath";
    static final String OperationTimeoutConfigName = "OperationTimeout";
    static final String RetryPolicyConfigName = "RetryPolicy";
    static final String KeyValueSeparator = "=";
    static final String KeyValuePairDelimiter = ";";
    private static final String AllKeyEnumerateRegex = "(Hostname|Endpoint|SharedAccessKeyName|SharedAccessKey|EntityPath|OperationTimeout|RetryPolicy)";
    private static final String KeysWithDelimitersRegex = ";(Hostname|Endpoint|SharedAccessKeyName|SharedAccessKey|EntityPath|OperationTimeout|RetryPolicy)=";
    private String connectionString;
    private URI endpoint;
    private String sharedAccessKeyName;
    private String sharedAccessKey;
    private String entityPath;
    private Duration operationTimeout;
    private RetryPolicy retryPolicy;

    private ConnectionStringBuilder(URI endpointAddress, String entityPath, String sharedAccessKeyName, String sharedAccessKey, Duration operationTimeout, RetryPolicy retryPolicy) {
        this.endpoint = endpointAddress;
        this.sharedAccessKey = sharedAccessKey;
        this.sharedAccessKeyName = sharedAccessKeyName;
        this.operationTimeout = operationTimeout;
        this.retryPolicy = retryPolicy;
        this.entityPath = entityPath;
    }

    private ConnectionStringBuilder(String namespaceName, String entityPath, String sharedAccessKeyName, String sharedAccessKey, Duration operationTimeout, RetryPolicy retryPolicy) {
        try {
            this.endpoint = new URI(String.format(Locale.US, endpointFormat, namespaceName));
        }
        catch (URISyntaxException exception) {
            throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Invalid namespace name: %s", namespaceName), exception);
        }
        this.sharedAccessKey = sharedAccessKey;
        this.sharedAccessKeyName = sharedAccessKeyName;
        this.operationTimeout = operationTimeout;
        this.retryPolicy = retryPolicy;
        this.entityPath = entityPath;
    }

    public ConnectionStringBuilder(String namespaceName, String entityPath, String sharedAccessKeyName, String sharedAccessKey) {
        this(namespaceName, entityPath, sharedAccessKeyName, sharedAccessKey, MessagingFactory.DefaultOperationTimeout, RetryPolicy.getDefault());
    }

    public ConnectionStringBuilder(URI endpointAddress, String entityPath, String sharedAccessKeyName, String sharedAccessKey) {
        this(endpointAddress, entityPath, sharedAccessKeyName, sharedAccessKey, MessagingFactory.DefaultOperationTimeout, RetryPolicy.getDefault());
    }

    public ConnectionStringBuilder(String connectionString) {
        this.parseConnectionString(connectionString);
        this.connectionString = connectionString;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public String getSasKey() {
        return this.sharedAccessKey;
    }

    public String getSasKeyName() {
        return this.sharedAccessKeyName;
    }

    public String getEntityPath() {
        return this.entityPath;
    }

    public Duration getOperationTimeout() {
        return this.operationTimeout == null ? MessagingFactory.DefaultOperationTimeout : this.operationTimeout;
    }

    public void setOperationTimeout(Duration operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy == null ? RetryPolicy.getDefault() : this.retryPolicy;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    public String toString() {
        if (StringUtil.isNullOrWhiteSpace(this.connectionString)) {
            StringBuilder connectionStringBuilder = new StringBuilder();
            if (this.endpoint != null) {
                connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", EndpointConfigName, KeyValueSeparator, this.endpoint.toString(), KeyValuePairDelimiter));
            }
            if (!StringUtil.isNullOrWhiteSpace(this.entityPath)) {
                connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", EntityPathConfigName, KeyValueSeparator, this.entityPath, KeyValuePairDelimiter));
            }
            if (!StringUtil.isNullOrWhiteSpace(this.sharedAccessKeyName)) {
                connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", SharedAccessKeyNameConfigName, KeyValueSeparator, this.sharedAccessKeyName, KeyValuePairDelimiter));
            }
            if (!StringUtil.isNullOrWhiteSpace(this.sharedAccessKey)) {
                connectionStringBuilder.append(String.format(Locale.US, "%s%s%s", SharedAccessKeyConfigName, KeyValueSeparator, this.sharedAccessKey));
            }
            if (this.operationTimeout != null) {
                connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", KeyValuePairDelimiter, OperationTimeoutConfigName, KeyValueSeparator, this.operationTimeout.toString()));
            }
            if (this.retryPolicy != null) {
                connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", KeyValuePairDelimiter, RetryPolicyConfigName, KeyValueSeparator, this.retryPolicy.toString()));
            }
            this.connectionString = connectionStringBuilder.toString();
        }
        return this.connectionString;
    }

    private void parseConnectionString(String connectionString) {
        if (StringUtil.isNullOrWhiteSpace(connectionString)) {
            throw new IllegalConnectionStringFormatException(String.format("connectionString cannot be empty", new Object[0]));
        }
        String connection = KeyValuePairDelimiter + connectionString;
        Pattern keyValuePattern = Pattern.compile(KeysWithDelimitersRegex, 2);
        String[] values = keyValuePattern.split(connection);
        Matcher keys = keyValuePattern.matcher(connection);
        if (values == null || values.length <= 1 || keys.groupCount() == 0) {
            throw new IllegalConnectionStringFormatException("Connection String cannot be parsed.");
        }
        if (!StringUtil.isNullOrWhiteSpace(values[0])) {
            throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Cannot parse part of ConnectionString: %s", values[0]));
        }
        int valueIndex = 0;
        while (keys.find()) {
            String key = keys.group();
            key = key.substring(1, key.length() - 1);
            if (values.length < ++valueIndex + 1) {
                throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Value for the connection string parameter name: %s, not found", key));
            }
            if (key.equalsIgnoreCase(EndpointConfigName)) {
                if (this.endpoint != null) {
                    throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Multiple %s and/or %s detected. Make sure only one is defined", EndpointConfigName, HostnameConfigName));
                }
                try {
                    this.endpoint = new URI(values[valueIndex]);
                    continue;
                }
                catch (URISyntaxException exception) {
                    throw new IllegalConnectionStringFormatException(String.format(Locale.US, "%s should be in format scheme://fullyQualifiedServiceBusNamespaceEndpointName", EndpointConfigName), exception);
                }
            }
            if (key.equalsIgnoreCase(HostnameConfigName)) {
                if (this.endpoint != null) {
                    throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Multiple %s and/or %s detected. Make sure only one is defined", EndpointConfigName, HostnameConfigName));
                }
                try {
                    this.endpoint = new URI(String.format(Locale.US, endpointRawFormat, values[valueIndex]));
                    continue;
                }
                catch (URISyntaxException exception) {
                    throw new IllegalConnectionStringFormatException(String.format(Locale.US, "%s should be a fully quantified host name address", HostnameConfigName), exception);
                }
            }
            if (key.equalsIgnoreCase(SharedAccessKeyNameConfigName)) {
                this.sharedAccessKeyName = values[valueIndex];
                continue;
            }
            if (key.equalsIgnoreCase(SharedAccessKeyConfigName)) {
                this.sharedAccessKey = values[valueIndex];
                continue;
            }
            if (key.equalsIgnoreCase(EntityPathConfigName)) {
                this.entityPath = values[valueIndex];
                continue;
            }
            if (key.equalsIgnoreCase(OperationTimeoutConfigName)) {
                try {
                    this.operationTimeout = Duration.parse(values[valueIndex]);
                    continue;
                }
                catch (DateTimeParseException exception) {
                    throw new IllegalConnectionStringFormatException("Invalid value specified for property 'Duration' in the ConnectionString.", exception);
                }
            }
            if (key.equalsIgnoreCase(RetryPolicyConfigName)) {
                RetryPolicy retryPolicy = values[valueIndex].equals("Default") ? RetryPolicy.getDefault() : (this.retryPolicy = values[valueIndex].equals("NoRetry") ? RetryPolicy.getNoRetry() : null);
                if (this.retryPolicy != null) continue;
                throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Connection string parameter '%s'='%s' is not recognized", RetryPolicyConfigName, values[valueIndex]));
            }
            throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Illegal connection string parameter name: %s", key));
        }
    }
}

