/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.ProxyConfiguration;
import com.microsoft.azure.eventhubs.TransportType;
import com.microsoft.azure.eventhubs.impl.AmqpConnection;
import com.microsoft.azure.eventhubs.impl.AmqpConstants;
import com.microsoft.azure.eventhubs.impl.ClientConstants;
import com.microsoft.azure.eventhubs.impl.EventHubClientImpl;
import com.microsoft.azure.eventhubs.impl.WebSocketConnectionHandler;
import com.microsoft.azure.eventhubs.impl.WebSocketProxyConnectionHandler;
import java.util.HashMap;
import java.util.Locale;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.SslDomain;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.TransportInternal;
import org.apache.qpid.proton.reactor.Handshaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionHandler
extends BaseHandler {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(ConnectionHandler.class);
    private final AmqpConnection amqpConnection;
    private final String connectionId;

    protected ConnectionHandler(AmqpConnection amqpConnection, String connectionId) {
        this.add((Handler)new Handshaker());
        this.amqpConnection = amqpConnection;
        this.connectionId = connectionId;
    }

    static ConnectionHandler create(TransportType transportType, AmqpConnection amqpConnection, String connectionId, ProxyConfiguration proxyConfiguration) {
        switch (transportType) {
            case AMQP_WEB_SOCKETS: {
                if (proxyConfiguration != null && proxyConfiguration.isProxyAddressConfigured() || WebSocketProxyConnectionHandler.shouldUseProxy(amqpConnection.getHostName()).booleanValue()) {
                    return new WebSocketProxyConnectionHandler(amqpConnection, proxyConfiguration);
                }
                return new WebSocketConnectionHandler(amqpConnection);
            }
        }
        return new ConnectionHandler(amqpConnection, connectionId);
    }

    private static SslDomain makeDomain(SslDomain.Mode mode) {
        SslDomain domain = Proton.sslDomain();
        domain.init(mode);
        domain.setPeerAuthentication(SslDomain.VerifyMode.ANONYMOUS_PEER);
        return domain;
    }

    protected AmqpConnection getAmqpConnection() {
        return this.amqpConnection;
    }

    public void onConnectionInit(Event event) {
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info(String.format(Locale.US, "onConnectionInit hostname[%s], connectionId[%s]", this.amqpConnection.getHostName(), this.connectionId));
        }
        Connection connection = event.getConnection();
        String hostName = this.amqpConnection.getHostName() + ":" + this.getProtocolPort();
        connection.setHostname(hostName);
        connection.setContainer(this.connectionId);
        HashMap<Symbol, String> connectionProperties = new HashMap<Symbol, String>();
        connectionProperties.put(AmqpConstants.PRODUCT, "MSJavaClient");
        connectionProperties.put(AmqpConstants.VERSION, "3.2.0");
        connectionProperties.put(AmqpConstants.PLATFORM, ClientConstants.PLATFORM_INFO);
        connectionProperties.put(AmqpConstants.FRAMEWORK, ClientConstants.FRAMEWORK_INFO);
        String userAgent = EventHubClientImpl.USER_AGENT;
        if (userAgent != null) {
            connectionProperties.put(AmqpConstants.USER_AGENT, userAgent.length() < 128 ? userAgent : userAgent.substring(0, 128));
        }
        connection.setProperties(connectionProperties);
        connection.open();
    }

    protected void addTransportLayers(Event event, TransportInternal transport) {
        SslDomain domain = ConnectionHandler.makeDomain(SslDomain.Mode.CLIENT);
        transport.ssl(domain);
    }

    protected void notifyTransportErrors(Event event) {
    }

    public String getRemoteHostName() {
        return this.amqpConnection.getHostName();
    }

    protected int getRemotePort() {
        return this.getProtocolPort();
    }

    protected int getProtocolPort() {
        return 5671;
    }

    protected int getMaxFrameSize() {
        return 65536;
    }

    public void onConnectionBound(Event event) {
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info(String.format(Locale.US, "onConnectionBound hostname[%s], connectionId[%s]", this.amqpConnection.getHostName(), this.connectionId));
        }
        Transport transport = event.getTransport();
        transport.setIdleTimeout(60000);
        this.addTransportLayers(event, (TransportInternal)transport);
    }

    public void onConnectionUnbound(Event event) {
        Connection connection = event.getConnection();
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info(String.format(Locale.US, "onConnectionUnbound hostname[%s], connectionId[%s], state[%s], remoteState[%s]", connection.getHostname(), this.connectionId, connection.getLocalState(), connection.getRemoteState()));
        }
        connection.free();
    }

    public void onTransportError(Event event) {
        Connection connection = event.getConnection();
        Transport transport = event.getTransport();
        ErrorCondition condition = transport.getCondition();
        if (TRACE_LOGGER.isWarnEnabled()) {
            TRACE_LOGGER.warn(String.format(Locale.US, "onTransportError hostname[%s], connectionId[%s], error[%s]", connection != null ? connection.getHostname() : "n/a", this.connectionId, condition != null ? condition.getDescription() : "n/a"));
        }
        if (connection != null && connection.getRemoteState() != EndpointState.CLOSED) {
            this.amqpConnection.onConnectionError(condition);
        }
        transport.unbind();
        this.notifyTransportErrors(event);
    }

    public void onTransportClosed(Event event) {
        Connection connection = event.getConnection();
        Transport transport = event.getTransport();
        ErrorCondition condition = transport.getCondition();
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info(String.format(Locale.US, "onTransportClosed hostname[%s], connectionId[%s], error[%s]", connection != null ? connection.getHostname() : "n/a", this.connectionId, condition != null ? condition.getDescription() : "n/a"));
        }
        if (connection != null && connection.getRemoteState() != EndpointState.CLOSED) {
            this.amqpConnection.onConnectionError(condition);
        }
    }

    public void onConnectionLocalOpen(Event event) {
        Connection connection = event.getConnection();
        ErrorCondition error = connection.getCondition();
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info(String.format(Locale.US, "onConnectionLocalOpen hostname[%s], connectionId[%s], errorCondition[%s], errorDescription[%s]", connection.getHostname(), this.connectionId, error != null ? error.getCondition() : "n/a", error != null ? error.getDescription() : "n/a"));
        }
    }

    public void onConnectionRemoteOpen(Event event) {
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info(String.format(Locale.US, "onConnectionRemoteOpen hostname[%s], connectionId[%s], remoteContainer[%s]", event.getConnection().getHostname(), this.connectionId, event.getConnection().getRemoteContainer()));
        }
        this.amqpConnection.onOpenComplete(null);
    }

    public void onConnectionLocalClose(Event event) {
        Transport transport;
        Connection connection = event.getConnection();
        ErrorCondition error = connection.getCondition();
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info(String.format(Locale.US, "onConnectionLocalClose hostname[%s], connectionId[%s], errorCondition[%s], errorDescription[%s]", connection.getHostname(), this.connectionId, error != null ? error.getCondition() : "n/a", error != null ? error.getDescription() : "n/a"));
        }
        if (connection.getRemoteState() == EndpointState.CLOSED && (transport = connection.getTransport()) != null) {
            transport.unbind();
        }
    }

    public void onConnectionRemoteClose(Event event) {
        Connection connection = event.getConnection();
        ErrorCondition error = connection.getRemoteCondition();
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info(String.format(Locale.US, "onConnectionRemoteClose hostname[%s], connectionId[%s], errorCondition[%s], errorDescription[%s]", connection.getHostname(), this.connectionId, error != null ? error.getCondition() : "n/a", error != null ? error.getDescription() : "n/a"));
        }
        this.amqpConnection.onConnectionError(error);
    }

    public void onConnectionFinal(Event event) {
        Connection connection = event.getConnection();
        ErrorCondition error = connection.getCondition();
        if (TRACE_LOGGER.isInfoEnabled()) {
            TRACE_LOGGER.info(String.format(Locale.US, "onConnectionFinal hostname[%s], connectionId[%s], errorCondition[%s], errorDescription[%s]", connection.getHostname(), this.connectionId, error != null ? error.getCondition() : "n/a", error != null ? error.getDescription() : "n/a"));
        }
    }
}

