/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.impl.DispatchHandler;
import com.microsoft.azure.eventhubs.impl.IOObject;
import com.microsoft.azure.eventhubs.impl.Operation;
import com.microsoft.azure.eventhubs.impl.OperationResult;
import com.microsoft.azure.eventhubs.impl.ReactorDispatcher;
import com.microsoft.azure.eventhubs.impl.StringUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaultTolerantObject<T extends IOObject> {
    private final Operation<T> openTask;
    private final Operation<Void> closeTask;
    private final Queue<OperationResult<T, Exception>> openCallbacks;
    private final Queue<OperationResult<Void, Exception>> closeCallbacks;
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(FaultTolerantObject.class);
    private final String instanceName = StringUtil.getRandomString("FTO");
    private final String clientId;
    private final String sessionName;
    private T innerObject;
    private final Object creatingSynchronizer = new Object();
    private volatile boolean creatingNewInnerObject;
    private final Object closingSynchronizer = new Object();
    private volatile boolean closingInnerObject;

    public FaultTolerantObject(Operation<T> openAsync, Operation<Void> closeAsync, String clientId, String sessionName) {
        this.openTask = openAsync;
        this.closeTask = closeAsync;
        this.openCallbacks = new ConcurrentLinkedQueue<OperationResult<T, Exception>>();
        this.closeCallbacks = new ConcurrentLinkedQueue<OperationResult<Void, Exception>>();
        this.clientId = clientId;
        this.sessionName = sessionName;
    }

    T unsafeGetIfOpened() {
        if (this.innerObject != null && this.innerObject.getState() == IOObject.IOObjectState.OPENED) {
            return this.innerObject;
        }
        return null;
    }

    public void runOnOpenedObject(ReactorDispatcher dispatcher, final OperationResult<T, Exception> openCallback) {
        try {
            dispatcher.invoke(new DispatchHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onEvent() {
                    boolean shouldCreateNewInnerObject = false;
                    Object object = FaultTolerantObject.this.creatingSynchronizer;
                    synchronized (object) {
                        if (!(FaultTolerantObject.this.creatingNewInnerObject || FaultTolerantObject.this.innerObject != null && FaultTolerantObject.this.innerObject.getState() != IOObject.IOObjectState.CLOSED && FaultTolerantObject.this.innerObject.getState() != IOObject.IOObjectState.CLOSING)) {
                            if (TRACE_LOGGER.isInfoEnabled()) {
                                TRACE_LOGGER.info(String.format(Locale.US, "FaultTolerantObject[%s] client[%s] session[%s] decided to create cNIO[%s] innerObject[%s] iOstate[%s]", FaultTolerantObject.this.instanceName, FaultTolerantObject.this.clientId, FaultTolerantObject.this.sessionName, FaultTolerantObject.this.creatingNewInnerObject ? "T" : "F", FaultTolerantObject.this.innerObject != null ? "not null" : "null", FaultTolerantObject.this.innerObject != null ? FaultTolerantObject.this.innerObject.getState().toString() : "--"));
                            }
                            shouldCreateNewInnerObject = true;
                            FaultTolerantObject.this.creatingNewInnerObject = true;
                        }
                    }
                    if (shouldCreateNewInnerObject) {
                        try {
                            FaultTolerantObject.this.openCallbacks.offer(openCallback);
                            FaultTolerantObject.this.openTask.run(new OperationResult<T, Exception>(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void onComplete(T result) {
                                    FaultTolerantObject.this.innerObject = result;
                                    for (OperationResult callback : FaultTolerantObject.this.openCallbacks) {
                                        callback.onComplete(result);
                                    }
                                    FaultTolerantObject.this.openCallbacks.clear();
                                    Object object = FaultTolerantObject.this.creatingSynchronizer;
                                    synchronized (object) {
                                        FaultTolerantObject.this.creatingNewInnerObject = false;
                                    }
                                    if (TRACE_LOGGER.isInfoEnabled()) {
                                        TRACE_LOGGER.info(String.format(Locale.US, "FaultTolerantObject[%s] client[%s] session[%s] inner object creation complete", FaultTolerantObject.this.instanceName, FaultTolerantObject.this.clientId, FaultTolerantObject.this.sessionName));
                                    }
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void onError(Exception error) {
                                    for (OperationResult callback : FaultTolerantObject.this.openCallbacks) {
                                        callback.onError(error);
                                    }
                                    FaultTolerantObject.this.openCallbacks.clear();
                                    Object object = FaultTolerantObject.this.creatingSynchronizer;
                                    synchronized (object) {
                                        FaultTolerantObject.this.creatingNewInnerObject = false;
                                    }
                                }
                            });
                        }
                        catch (RuntimeException re) {
                            Object object2 = FaultTolerantObject.this.creatingSynchronizer;
                            synchronized (object2) {
                                FaultTolerantObject.this.creatingNewInnerObject = false;
                            }
                            throw re;
                        }
                    }
                    if (FaultTolerantObject.this.innerObject != null && FaultTolerantObject.this.innerObject.getState() == IOObject.IOObjectState.OPENED) {
                        openCallback.onComplete(FaultTolerantObject.this.innerObject);
                    } else {
                        FaultTolerantObject.this.openCallbacks.offer(openCallback);
                    }
                }
            });
        }
        catch (IOException ioException) {
            openCallback.onError(ioException);
        }
    }

    public void close(ReactorDispatcher dispatcher, final OperationResult<Void, Exception> closeCallback) {
        try {
            dispatcher.invoke(new DispatchHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onEvent() {
                    if (FaultTolerantObject.this.innerObject == null || FaultTolerantObject.this.innerObject.getState() == IOObject.IOObjectState.CLOSED) {
                        closeCallback.onComplete(null);
                    } else {
                        boolean shouldClose = false;
                        Object object = FaultTolerantObject.this.closingSynchronizer;
                        synchronized (object) {
                            if (!(FaultTolerantObject.this.closingInnerObject || FaultTolerantObject.this.innerObject.getState() != IOObject.IOObjectState.OPENED && FaultTolerantObject.this.innerObject.getState() != IOObject.IOObjectState.OPENING)) {
                                shouldClose = true;
                                FaultTolerantObject.this.closingInnerObject = true;
                            }
                        }
                        if (shouldClose) {
                            FaultTolerantObject.this.closeCallbacks.offer(closeCallback);
                            FaultTolerantObject.this.closeTask.run(new OperationResult<Void, Exception>(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void onComplete(Void result) {
                                    Iterator iterator = FaultTolerantObject.this.closingSynchronizer;
                                    synchronized (iterator) {
                                        FaultTolerantObject.this.closingInnerObject = false;
                                    }
                                    for (OperationResult callback : FaultTolerantObject.this.closeCallbacks) {
                                        callback.onComplete(result);
                                    }
                                    FaultTolerantObject.this.closeCallbacks.clear();
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void onError(Exception error) {
                                    Iterator iterator = FaultTolerantObject.this.closingSynchronizer;
                                    synchronized (iterator) {
                                        FaultTolerantObject.this.closingInnerObject = false;
                                    }
                                    for (OperationResult callback : FaultTolerantObject.this.closeCallbacks) {
                                        callback.onError(error);
                                    }
                                    FaultTolerantObject.this.closeCallbacks.clear();
                                }
                            });
                        } else {
                            FaultTolerantObject.this.closeCallbacks.offer(closeCallback);
                        }
                    }
                }
            });
        }
        catch (IOException ioException) {
            closeCallback.onError(ioException);
        }
    }
}

