/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.requests;

import com.microsoft.azure.keyvault.models.Attributes;
import com.microsoft.azure.keyvault.models.CertificateAttributes;
import com.microsoft.azure.keyvault.models.CertificatePolicy;
import com.microsoft.azure.keyvault.models.IssuerParameters;
import com.microsoft.azure.keyvault.models.KeyProperties;
import com.microsoft.azure.keyvault.models.LifetimeAction;
import com.microsoft.azure.keyvault.models.SecretProperties;
import com.microsoft.azure.keyvault.models.X509CertificateProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public final class ImportCertificateRequest {
    private final String vaultBaseUrl;
    private final String certificateName;
    private final String base64EncodedCertificate;
    private final String password;
    private final CertificatePolicy certificatePolicy;
    private final CertificateAttributes certificateAttributes;
    private final Map<String, String> tags;

    private ImportCertificateRequest(Builder builder) {
        this.vaultBaseUrl = builder.vaultBaseUrl;
        this.certificateName = builder.certificateName;
        this.base64EncodedCertificate = builder.base64EncodedCertificate;
        this.password = builder.password;
        this.certificateAttributes = builder.attributes != null ? (CertificateAttributes)new CertificateAttributes().withNotBefore(builder.attributes.notBefore()).withEnabled(builder.attributes.enabled()).withExpires(builder.attributes.expires()) : null;
        if (builder.policy != null) {
            this.certificatePolicy = new CertificatePolicy();
            if (builder.policy.attributes() != null) {
                this.certificatePolicy.withAttributes((CertificateAttributes)new CertificateAttributes().withEnabled(builder.policy.attributes().enabled()).withExpires(builder.policy.attributes().expires()).withNotBefore(builder.policy.attributes().notBefore()));
            }
            if (builder.policy.issuerParameters() != null) {
                this.certificatePolicy.withIssuerParameters(new IssuerParameters().withName(builder.policy.issuerParameters().name()));
            }
            if (builder.policy.x509CertificateProperties() != null) {
                this.certificatePolicy.withX509CertificateProperties(new X509CertificateProperties().withValidityInMonths(builder.policy.x509CertificateProperties().validityInMonths()).withSubjectAlternativeNames(builder.policy.x509CertificateProperties().subjectAlternativeNames()).withSubject(builder.policy.x509CertificateProperties().subject()).withEkus(builder.policy.x509CertificateProperties().ekus()).withKeyUsage(builder.policy.x509CertificateProperties().keyUsage()));
            }
            if (builder.policy.lifetimeActions() != null) {
                this.certificatePolicy.withLifetimeActions(new ArrayList<LifetimeAction>(builder.policy.lifetimeActions()));
            }
            if (builder.policy.keyProperties() != null) {
                this.certificatePolicy.withKeyProperties(new KeyProperties().withExportable(builder.policy.keyProperties().exportable()).withKeySize(builder.policy.keyProperties().keySize()).withKeyType(builder.policy.keyProperties().keyType()).withReuseKey(builder.policy.keyProperties().reuseKey()));
            }
            if (builder.policy.secretProperties() != null) {
                this.certificatePolicy.withSecretProperties(new SecretProperties().withContentType(builder.policy.secretProperties().contentType()));
            }
        } else {
            this.certificatePolicy = null;
        }
        this.tags = builder.tags != null ? Collections.unmodifiableMap(builder.tags) : null;
    }

    public String vaultBaseUrl() {
        return this.vaultBaseUrl;
    }

    public String certificateName() {
        return this.certificateName;
    }

    public String base64EncodedCertificate() {
        return this.base64EncodedCertificate;
    }

    public String password() {
        return this.password;
    }

    public CertificatePolicy certificatePolicy() {
        return this.certificatePolicy;
    }

    public CertificateAttributes certificateAttributes() {
        return this.certificateAttributes;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public static class Builder {
        private final String vaultBaseUrl;
        private final String certificateName;
        private final String base64EncodedCertificate;
        private String password;
        private CertificatePolicy policy;
        private CertificateAttributes attributes;
        private Map<String, String> tags;

        public Builder(String vaultBaseUrl, String certificateName, String base64EncodedCertificate) {
            this.vaultBaseUrl = vaultBaseUrl;
            this.certificateName = certificateName;
            this.base64EncodedCertificate = base64EncodedCertificate;
        }

        public Builder withPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder withPolicy(CertificatePolicy policy) {
            this.policy = policy;
            return this;
        }

        public Builder withAttributes(Attributes attributes) {
            this.attributes = (CertificateAttributes)attributes;
            return this;
        }

        public Builder withTags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public ImportCertificateRequest build() {
            return new ImportCertificateRequest(this);
        }
    }
}

