/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven;

import com.microsoft.applicationinsights.internal.channel.common.ApacheSenderFactory;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.auth.AzureAuthHelper;
import com.microsoft.azure.auth.AzureTokenWrapper;
import com.microsoft.azure.auth.MavenSettingHelper;
import com.microsoft.azure.auth.configuration.AuthType;
import com.microsoft.azure.auth.exception.AzureLoginFailureException;
import com.microsoft.azure.auth.exception.MavenDecryptException;
import com.microsoft.azure.common.ConfigurationProblem;
import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.common.logging.Log;
import com.microsoft.azure.common.utils.GetHashMac;
import com.microsoft.azure.management.Azure;
import com.microsoft.azure.maven.auth.AuthConfiguration;
import com.microsoft.azure.maven.auth.AuthenticationSetting;
import com.microsoft.azure.maven.auth.AzureAuthFailureException;
import com.microsoft.azure.maven.auth.AzureAuthHelperLegacy;
import com.microsoft.azure.maven.auth.AzureClientFactory;
import com.microsoft.azure.maven.common.utils.MavenUtils;
import com.microsoft.azure.maven.telemetry.AppInsightsProxy;
import com.microsoft.azure.maven.telemetry.TelemetryConfiguration;
import com.microsoft.azure.maven.telemetry.TelemetryProxy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public abstract class AbstractAzureMojo
extends AbstractMojo
implements TelemetryConfiguration,
AuthConfiguration {
    public static final String PLUGIN_NAME_KEY = "pluginName";
    public static final String PLUGIN_VERSION_KEY = "pluginVersion";
    public static final String INSTALLATION_ID_KEY = "installationId";
    public static final String SESSION_ID_KEY = "sessionId";
    public static final String SUBSCRIPTION_ID_KEY = "subscriptionId";
    public static final String AUTH_TYPE = "authType";
    public static final String AUTH_METHOD = "authMethod";
    public static final String TELEMETRY_NOT_ALLOWED = "TelemetryNotAllowed";
    public static final String INIT_FAILURE = "InitFailure";
    public static final String AZURE_INIT_FAIL = "Failed to authenticate with Azure. Please check your configuration.";
    public static final String FAILURE_REASON = "failureReason";
    private static final String CONFIGURATION_PATH = Paths.get(System.getProperty("user.home"), ".azure", "mavenplugins.properties").toString();
    private static final String FIRST_RUN_KEY = "first.run";
    private static final String PRIVACY_STATEMENT = "\nData/Telemetry\n---------\nThis project collects usage data and sends it to Microsoft to help improve our products and services.\nRead Microsoft's privacy statement to learn more: https://privacy.microsoft.com/en-us/privacystatement.\n\nYou can change your telemetry configuration through 'allowTelemetry' property.\nFor more information, please go to https://aka.ms/azure-maven-config.\n";
    private static final String INVALID_AUTH_TYPE = "'%s' is not a valid auth type for Azure maven plugins, supported values are %s. Will use 'auto' by default.";
    private static final String UNSUPPORTED_AZURE_ENVIRONMENT = "Unsupported Azure environment %s, using Azure by default.";
    private static final String USING_AZURE_ENVIRONMENT = "Using Azure environment : %s.";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    protected File buildDirectory;
    @Parameter(defaultValue="${plugin}", readonly=true, required=true)
    protected PluginDescriptor plugin;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    protected Settings settings;
    @Component(role=MavenResourcesFiltering.class, hint="default")
    protected MavenResourcesFiltering mavenResourcesFiltering;
    @Parameter
    protected AuthenticationSetting authentication;
    @Parameter
    protected String subscriptionId = "";
    @Parameter(property="allowTelemetry", defaultValue="true")
    protected boolean allowTelemetry;
    @Parameter(property="failsOnError", defaultValue="true")
    protected boolean failsOnError;
    @Parameter(property="httpProxyHost", readonly=false, required=false)
    protected String httpProxyHost;
    @Parameter(property="httpProxyPort", defaultValue="80")
    protected int httpProxyPort;
    @Parameter(property="authType")
    protected String authType;
    @Parameter(property="auth")
    protected com.microsoft.azure.auth.configuration.AuthConfiguration auth;
    @Component
    protected SettingsDecrypter settingsDecrypter;
    private Azure azure;
    private TelemetryProxy telemetryProxy;
    private AzureTokenWrapper azureTokenWrapper;
    private String sessionId = UUID.randomUUID().toString();
    private String installationId = GetHashMac.getHashMac();
    private boolean authInitialized = false;

    public MavenProject getProject() {
        return this.project;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public String getBuildDirectoryAbsolutePath() {
        return this.buildDirectory.getAbsolutePath();
    }

    public MavenResourcesFiltering getMavenResourcesFiltering() {
        return this.mavenResourcesFiltering;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public AuthenticationSetting getAuthenticationSetting() {
        return this.authentication;
    }

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public boolean isTelemetryAllowed() {
        return this.allowTelemetry;
    }

    public boolean isFailingOnError() {
        return this.failsOnError;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getInstallationId() {
        return this.installationId == null ? "" : this.installationId;
    }

    public String getPluginName() {
        return this.plugin.getArtifactId();
    }

    public String getPluginVersion() {
        return this.plugin.getVersion();
    }

    @Override
    public String getUserAgent() {
        return this.isTelemetryAllowed() ? String.format("%s/%s %s:%s %s:%s", this.getPluginName(), this.getPluginVersion(), INSTALLATION_ID_KEY, this.getInstallationId(), SESSION_ID_KEY, this.getSessionId()) : String.format("%s/%s", this.getPluginName(), this.getPluginVersion());
    }

    @Override
    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    @Override
    public int getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public Azure getAzureClient() throws AzureAuthFailureException {
        if (this.azure == null) {
            if (this.authentication != null && (this.authentication.getFile() != null || StringUtils.isNotBlank((CharSequence)this.authentication.getServerId()))) {
                Log.warn((String)"You are using an old way of authentication which will be deprecated in future versions, please change your configurations.");
                this.azure = new AzureAuthHelperLegacy(this).getAzureClient();
            } else {
                this.initAuth();
                this.azure = this.getAzureClientByAuthType();
            }
            if (this.azure == null) {
                this.getTelemetryProxy().trackEvent(INIT_FAILURE);
                throw new AzureAuthFailureException(AZURE_INIT_FAIL);
            }
            this.getTelemetryProxy().addDefaultProperty(AUTH_TYPE, this.authType);
            this.getTelemetryProxy().addDefaultProperty(AUTH_METHOD, this.getAuthMethod());
            this.getTelemetryProxy().addDefaultProperty(SUBSCRIPTION_ID_KEY, this.azure.subscriptionId());
        }
        return this.azure;
    }

    protected Azure getAzureClientByAuthType() throws AzureAuthFailureException {
        try {
            AzureEnvironment environment;
            if (!AzureAuthHelper.validateEnvironment((String)this.auth.getEnvironment())) {
                Log.prompt((String)String.format(UNSUPPORTED_AZURE_ENVIRONMENT, this.auth.getEnvironment()));
                environment = AzureEnvironment.AZURE;
            } else {
                environment = AzureAuthHelper.getAzureEnvironment((String)this.auth.getEnvironment());
            }
            String environmentName = AzureAuthHelper.getAzureEnvironmentDisplayName((AzureEnvironment)environment);
            if (environment != AzureEnvironment.AZURE) {
                Log.prompt((String)String.format(USING_AZURE_ENVIRONMENT, environmentName));
            }
            this.azureTokenWrapper = this.getAuthTypeEnum().getAzureToken(this.isAuthConfigurationExist() ? this.auth : null, environment);
            return this.azureTokenWrapper == null ? null : AzureClientFactory.getAzureClient(this.azureTokenWrapper, this.subscriptionId, this.getUserAgent());
        }
        catch (AzureLoginFailureException | IOException e) {
            throw new AzureAuthFailureException(e.getMessage());
        }
    }

    protected AzureTokenWrapper getAzureTokenWrapper() {
        return this.azureTokenWrapper;
    }

    protected AuthType getAuthTypeEnum() {
        if (StringUtils.isEmpty((CharSequence)this.authType)) {
            return AuthType.AUTO;
        }
        AuthType result = Arrays.stream(AuthType.getValidAuthTypes()).filter(authTypeEnum -> StringUtils.equalsAnyIgnoreCase((CharSequence)authTypeEnum.name(), (CharSequence[])new CharSequence[]{this.authType})).findFirst().orElse(null);
        if (result == null) {
            String validAuthTypes = Arrays.stream(AuthType.getValidAuthTypes()).map(authType -> String.format("'%s'", StringUtils.lowerCase((String)authType.name()))).collect(Collectors.joining(", "));
            Log.warn((String)String.format(INVALID_AUTH_TYPE, this.authType, validAuthTypes));
            result = AuthType.AUTO;
        }
        return result;
    }

    public TelemetryProxy getTelemetryProxy() {
        if (this.telemetryProxy == null) {
            this.initTelemetry();
        }
        return this.telemetryProxy;
    }

    protected void initTelemetry() {
        this.telemetryProxy = new AppInsightsProxy(this);
        if (!this.isTelemetryAllowed()) {
            this.telemetryProxy.trackEvent(TELEMETRY_NOT_ALLOWED);
            this.telemetryProxy.disable();
        }
    }

    protected void initAuth() throws AzureAuthFailureException {
        this.initializeAuthConfiguration();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initializeAuthConfiguration() throws AzureAuthFailureException {
        if (this.authInitialized) {
            return;
        }
        this.authInitialized = true;
        if (!this.isAuthConfigurationExist()) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)this.auth.getServerId())) {
            if (this.settings.getServer(this.auth.getServerId()) == null) throw new AzureAuthFailureException(String.format("Unable to get server('%s') from settings.xml.", this.auth.getServerId()));
            try {
                this.auth = MavenSettingHelper.getAuthConfigurationFromServer((MavenSession)this.session, (SettingsDecrypter)this.settingsDecrypter, (String)this.auth.getServerId());
                return;
            }
            catch (MavenDecryptException e) {
                throw new AzureAuthFailureException(e.getMessage());
            }
        } else {
            List problems;
            if (this.getAuthTypeEnum() != AuthType.SERVICE_PRINCIPAL || !(problems = this.auth.validate()).stream().anyMatch(problem -> problem.getSeverity() == ConfigurationProblem.Severity.ERROR)) return;
            throw new AzureAuthFailureException(String.format("Unable to validate auth configuration due to the following errors: %s", problems.stream().map(ConfigurationProblem::getErrorMessage).collect(Collectors.joining("\n"))));
        }
    }

    protected boolean isAuthConfigurationExist() {
        String pluginKey = this.plugin.getPluginLookupKey();
        Xpp3Dom pluginDom = MavenUtils.getPluginConfiguration((MavenProject)this.project, (String)pluginKey);
        if (pluginDom == null) {
            return false;
        }
        Xpp3Dom authDom = pluginDom.getChild("auth");
        return authDom != null && authDom.getChildren().length > 0;
    }

    @Override
    public Map<String, String> getTelemetryProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(INSTALLATION_ID_KEY, this.getInstallationId());
        map.put(PLUGIN_NAME_KEY, this.getPluginName());
        map.put(PLUGIN_VERSION_KEY, this.getPluginVersion());
        map.put(SUBSCRIPTION_ID_KEY, this.getSubscriptionId());
        map.put(SESSION_ID_KEY, this.getSessionId());
        return map;
    }

    public String getAuthMethod() {
        if (this.azureTokenWrapper != null) {
            return this.azureTokenWrapper.getAuthMethod().name();
        }
        AuthenticationSetting authSetting = this.getAuthenticationSetting();
        if (authSetting == null) {
            return "AzureCLI";
        }
        if (StringUtils.isNotEmpty((CharSequence)authSetting.getServerId())) {
            return "ServerId";
        }
        if (authSetting.getFile() != null) {
            return "AuthFile";
        }
        return "Unknown";
    }

    public void execute() throws MojoExecutionException {
        try {
            Thread.setDefaultUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler());
            Properties prop = new Properties();
            if (this.isFirstRun(prop)) {
                this.infoWithMultipleLines(PRIVACY_STATEMENT);
                this.updateConfigurationFile(prop);
            }
            if (this.isSkipMojo()) {
                Log.info((String)"Skip execution.");
                this.trackMojoSkip();
            } else {
                this.trackMojoStart();
                this.doExecute();
                this.trackMojoSuccess();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
            ApacheSenderFactory.INSTANCE.create().close();
        }
    }

    protected boolean isSkipMojo() {
        return false;
    }

    protected abstract void doExecute() throws AzureExecutionException;

    protected void trackMojoSkip() {
        this.getTelemetryProxy().trackEvent(this.getClass().getSimpleName() + ".skip");
    }

    protected void trackMojoStart() {
        this.getTelemetryProxy().trackEvent(this.getClass().getSimpleName() + ".start");
    }

    protected void trackMojoSuccess() {
        this.getTelemetryProxy().trackEvent(this.getClass().getSimpleName() + ".success");
    }

    protected void trackMojoFailure(String message) {
        HashMap<String, String> failureReason = new HashMap<String, String>();
        failureReason.put(FAILURE_REASON, message);
        this.getTelemetryProxy().trackEvent(this.getClass().getSimpleName() + ".failure", failureReason);
    }

    protected void handleException(Exception exception) throws MojoExecutionException {
        String message = exception.getMessage();
        if (StringUtils.isEmpty((CharSequence)message)) {
            message = exception.toString();
        }
        this.trackMojoFailure(message);
        if (this.isFailingOnError()) {
            throw new MojoExecutionException(message, exception);
        }
        Log.error((String)message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isFirstRun(Properties prop) {
        try {
            File configurationFile = new File(CONFIGURATION_PATH);
            if (!configurationFile.exists()) {
                configurationFile.getParentFile().mkdirs();
                configurationFile.createNewFile();
                return true;
            }
            try (FileInputStream input = new FileInputStream(CONFIGURATION_PATH);){
                prop.load(input);
                String firstRunValue = prop.getProperty(FIRST_RUN_KEY);
                if (firstRunValue == null) return true;
                if (firstRunValue.isEmpty()) return true;
                if (!firstRunValue.equalsIgnoreCase("false")) return true;
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            Log.debug((String)e.getMessage());
        }
        return true;
    }

    private void updateConfigurationFile(Properties prop) {
        try (FileOutputStream output = new FileOutputStream(CONFIGURATION_PATH);){
            prop.setProperty(FIRST_RUN_KEY, "false");
            prop.store(output, "Azure Maven Plugin configurations");
        }
        catch (Exception e) {
            Log.debug((String)e.getMessage());
        }
    }

    public void infoWithMultipleLines(String messages) {
        String[] messageArray;
        for (String line : messageArray = messages.split("\\n")) {
            Log.info((String)line);
        }
    }

    protected class DefaultUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        protected DefaultUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            Log.debug((String)("uncaughtException: " + e));
        }
    }
}

