/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.auth;

import com.google.common.base.Preconditions;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.auth.AzureTokenWrapper;
import com.microsoft.azure.auth.exception.AzureLoginFailureException;
import com.microsoft.azure.common.logging.Log;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.Azure;
import com.microsoft.azure.management.resources.Subscription;
import com.microsoft.azure.maven.auth.AzureAuthHelperLegacy;
import java.io.IOException;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class AzureClientFactory {
    private static final String SUBSCRIPTION_TEMPLATE = "Subscription : %s(%s)";
    public static final String SUBSCRIPTION_NOT_FOUND = "Subscription %s was not found in current account.";
    public static final String NO_AVAILABLE_SUBSCRIPTION = "No available subscription found in current account.";
    public static final String SUBSCRIPTION_NOT_SPECIFIED = "Subscription ID was not specified, using the first subscription in current account, please refer https://github.com/microsoft/azure-maven-plugins/wiki/Authentication#subscription for more information.";

    public static Azure getAzureClient(AzureTokenWrapper azureTokenCredentials, String subscriptionId, String userAgent) throws IOException, AzureLoginFailureException {
        Preconditions.checkNotNull((Object)azureTokenCredentials, (Object)"The parameter 'azureTokenCredentials' cannot be null.");
        Log.info((String)azureTokenCredentials.getCredentialDescription());
        Azure.Authenticated authenticated = ((Azure.Configurable)Azure.configure().withUserAgent(userAgent)).authenticate((AzureTokenCredentials)azureTokenCredentials);
        if (StringUtils.isEmpty((CharSequence)subscriptionId) && AzureAuthHelperLegacy.isInCloudShell()) {
            subscriptionId = AzureAuthHelperLegacy.getSubscriptionOfCloudShell();
        }
        subscriptionId = StringUtils.isEmpty((CharSequence)subscriptionId) ? azureTokenCredentials.defaultSubscriptionId() : subscriptionId;
        Azure azureClient = StringUtils.isEmpty((CharSequence)subscriptionId) ? authenticated.withDefaultSubscription() : authenticated.withSubscription(subscriptionId);
        AzureClientFactory.checkSubscription(azureClient, subscriptionId);
        Subscription subscription = azureClient.getCurrentSubscription();
        Log.info((String)String.format(SUBSCRIPTION_TEMPLATE, subscription.displayName(), subscription.subscriptionId()));
        return azureClient;
    }

    private static void checkSubscription(Azure azure, String targetSubscription) throws AzureLoginFailureException {
        PagedList subscriptions = azure.subscriptions().list();
        subscriptions.loadAll();
        if (subscriptions.size() == 0) {
            throw new AzureLoginFailureException(NO_AVAILABLE_SUBSCRIPTION);
        }
        if (StringUtils.isEmpty((CharSequence)targetSubscription)) {
            Log.warn((String)SUBSCRIPTION_NOT_SPECIFIED);
            return;
        }
        Optional<Subscription> optionalSubscription = subscriptions.stream().filter(subscription -> StringUtils.equals((CharSequence)subscription.subscriptionId(), (CharSequence)targetSubscription)).findAny();
        if (!optionalSubscription.isPresent()) {
            throw new AzureLoginFailureException(String.format(SUBSCRIPTION_NOT_FOUND, targetSubscription));
        }
    }
}

