/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.management.appservice.ComputeModeOptions;
import com.microsoft.azure.management.appservice.WorkerSizeOptions;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Stamp capacity information.
 */
public class StampCapacityInner {
    /**
     * Name of the stamp.
     */
    @JsonProperty(value = "name")
    private String name;

    /**
     * Available capacity (# of machines, bytes of storage etc...).
     */
    @JsonProperty(value = "availableCapacity")
    private Long availableCapacity;

    /**
     * Total capacity (# of machines, bytes of storage etc...).
     */
    @JsonProperty(value = "totalCapacity")
    private Long totalCapacity;

    /**
     * Name of the unit.
     */
    @JsonProperty(value = "unit")
    private String unit;

    /**
     * Shared/dedicated workers. Possible values include: 'Shared',
     * 'Dedicated', 'Dynamic'.
     */
    @JsonProperty(value = "computeMode")
    private ComputeModeOptions computeMode;

    /**
     * Size of the machines. Possible values include: 'Small', 'Medium',
     * 'Large', 'D1', 'D2', 'D3', 'Default'.
     */
    @JsonProperty(value = "workerSize")
    private WorkerSizeOptions workerSize;

    /**
     * Size ID of machines:
     * 0 - Small
     * 1 - Medium
     * 2 - Large.
     */
    @JsonProperty(value = "workerSizeId")
    private Integer workerSizeId;

    /**
     * If &lt;code&gt;true&lt;/code&gt;, it includes basic apps.
     * Basic apps are not used for capacity allocation.
     */
    @JsonProperty(value = "excludeFromCapacityAllocation")
    private Boolean excludeFromCapacityAllocation;

    /**
     * &lt;code&gt;true&lt;/code&gt; if capacity is applicable for all apps;
     * otherwise, &lt;code&gt;false&lt;/code&gt;.
     */
    @JsonProperty(value = "isApplicableForAllComputeModes")
    private Boolean isApplicableForAllComputeModes;

    /**
     * Shared or Dedicated.
     */
    @JsonProperty(value = "siteMode")
    private String siteMode;

    /**
     * Is this a linux stamp capacity.
     */
    @JsonProperty(value = "isLinux")
    private Boolean isLinux;

    /**
     * Get name of the stamp.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set name of the stamp.
     *
     * @param name the name value to set
     * @return the StampCapacityInner object itself.
     */
    public StampCapacityInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get available capacity (# of machines, bytes of storage etc...).
     *
     * @return the availableCapacity value
     */
    public Long availableCapacity() {
        return this.availableCapacity;
    }

    /**
     * Set available capacity (# of machines, bytes of storage etc...).
     *
     * @param availableCapacity the availableCapacity value to set
     * @return the StampCapacityInner object itself.
     */
    public StampCapacityInner withAvailableCapacity(Long availableCapacity) {
        this.availableCapacity = availableCapacity;
        return this;
    }

    /**
     * Get total capacity (# of machines, bytes of storage etc...).
     *
     * @return the totalCapacity value
     */
    public Long totalCapacity() {
        return this.totalCapacity;
    }

    /**
     * Set total capacity (# of machines, bytes of storage etc...).
     *
     * @param totalCapacity the totalCapacity value to set
     * @return the StampCapacityInner object itself.
     */
    public StampCapacityInner withTotalCapacity(Long totalCapacity) {
        this.totalCapacity = totalCapacity;
        return this;
    }

    /**
     * Get name of the unit.
     *
     * @return the unit value
     */
    public String unit() {
        return this.unit;
    }

    /**
     * Set name of the unit.
     *
     * @param unit the unit value to set
     * @return the StampCapacityInner object itself.
     */
    public StampCapacityInner withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    /**
     * Get shared/dedicated workers. Possible values include: 'Shared', 'Dedicated', 'Dynamic'.
     *
     * @return the computeMode value
     */
    public ComputeModeOptions computeMode() {
        return this.computeMode;
    }

    /**
     * Set shared/dedicated workers. Possible values include: 'Shared', 'Dedicated', 'Dynamic'.
     *
     * @param computeMode the computeMode value to set
     * @return the StampCapacityInner object itself.
     */
    public StampCapacityInner withComputeMode(ComputeModeOptions computeMode) {
        this.computeMode = computeMode;
        return this;
    }

    /**
     * Get size of the machines. Possible values include: 'Small', 'Medium', 'Large', 'D1', 'D2', 'D3', 'Default'.
     *
     * @return the workerSize value
     */
    public WorkerSizeOptions workerSize() {
        return this.workerSize;
    }

    /**
     * Set size of the machines. Possible values include: 'Small', 'Medium', 'Large', 'D1', 'D2', 'D3', 'Default'.
     *
     * @param workerSize the workerSize value to set
     * @return the StampCapacityInner object itself.
     */
    public StampCapacityInner withWorkerSize(WorkerSizeOptions workerSize) {
        this.workerSize = workerSize;
        return this;
    }

    /**
     * Get size ID of machines:
     0 - Small
     1 - Medium
     2 - Large.
     *
     * @return the workerSizeId value
     */
    public Integer workerSizeId() {
        return this.workerSizeId;
    }

    /**
     * Set size ID of machines:
     0 - Small
     1 - Medium
     2 - Large.
     *
     * @param workerSizeId the workerSizeId value to set
     * @return the StampCapacityInner object itself.
     */
    public StampCapacityInner withWorkerSizeId(Integer workerSizeId) {
        this.workerSizeId = workerSizeId;
        return this;
    }

    /**
     * Get if &lt;code&gt;true&lt;/code&gt;, it includes basic apps.
     Basic apps are not used for capacity allocation.
     *
     * @return the excludeFromCapacityAllocation value
     */
    public Boolean excludeFromCapacityAllocation() {
        return this.excludeFromCapacityAllocation;
    }

    /**
     * Set if &lt;code&gt;true&lt;/code&gt;, it includes basic apps.
     Basic apps are not used for capacity allocation.
     *
     * @param excludeFromCapacityAllocation the excludeFromCapacityAllocation value to set
     * @return the StampCapacityInner object itself.
     */
    public StampCapacityInner withExcludeFromCapacityAllocation(Boolean excludeFromCapacityAllocation) {
        this.excludeFromCapacityAllocation = excludeFromCapacityAllocation;
        return this;
    }

    /**
     * Get &lt;code&gt;true&lt;/code&gt; if capacity is applicable for all apps; otherwise, &lt;code&gt;false&lt;/code&gt;.
     *
     * @return the isApplicableForAllComputeModes value
     */
    public Boolean isApplicableForAllComputeModes() {
        return this.isApplicableForAllComputeModes;
    }

    /**
     * Set &lt;code&gt;true&lt;/code&gt; if capacity is applicable for all apps; otherwise, &lt;code&gt;false&lt;/code&gt;.
     *
     * @param isApplicableForAllComputeModes the isApplicableForAllComputeModes value to set
     * @return the StampCapacityInner object itself.
     */
    public StampCapacityInner withIsApplicableForAllComputeModes(Boolean isApplicableForAllComputeModes) {
        this.isApplicableForAllComputeModes = isApplicableForAllComputeModes;
        return this;
    }

    /**
     * Get shared or Dedicated.
     *
     * @return the siteMode value
     */
    public String siteMode() {
        return this.siteMode;
    }

    /**
     * Set shared or Dedicated.
     *
     * @param siteMode the siteMode value to set
     * @return the StampCapacityInner object itself.
     */
    public StampCapacityInner withSiteMode(String siteMode) {
        this.siteMode = siteMode;
        return this;
    }

    /**
     * Get is this a linux stamp capacity.
     *
     * @return the isLinux value
     */
    public Boolean isLinux() {
        return this.isLinux;
    }

    /**
     * Set is this a linux stamp capacity.
     *
     * @param isLinux the isLinux value to set
     * @return the StampCapacityInner object itself.
     */
    public StampCapacityInner withIsLinux(Boolean isLinux) {
        this.isLinux = isLinux;
        return this;
    }

}
