/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.management.appservice.ComputeModeOptions;
import java.util.List;
import com.microsoft.azure.management.appservice.SkuDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.management.appservice.ProxyOnlyResource;

/**
 * Worker pool of an App Service Environment ARM resource.
 */
@JsonFlatten
public class WorkerPoolResourceInner extends ProxyOnlyResource {
    /**
     * Worker size ID for referencing this worker pool.
     */
    @JsonProperty(value = "properties.workerSizeId")
    private Integer workerSizeId;

    /**
     * Shared or dedicated app hosting. Possible values include: 'Shared',
     * 'Dedicated', 'Dynamic'.
     */
    @JsonProperty(value = "properties.computeMode")
    private ComputeModeOptions computeMode;

    /**
     * VM size of the worker pool instances.
     */
    @JsonProperty(value = "properties.workerSize")
    private String workerSize;

    /**
     * Number of instances in the worker pool.
     */
    @JsonProperty(value = "properties.workerCount")
    private Integer workerCount;

    /**
     * Names of all instances in the worker pool (read only).
     */
    @JsonProperty(value = "properties.instanceNames", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> instanceNames;

    /**
     * The sku property.
     */
    @JsonProperty(value = "sku")
    private SkuDescription sku;

    /**
     * Get worker size ID for referencing this worker pool.
     *
     * @return the workerSizeId value
     */
    public Integer workerSizeId() {
        return this.workerSizeId;
    }

    /**
     * Set worker size ID for referencing this worker pool.
     *
     * @param workerSizeId the workerSizeId value to set
     * @return the WorkerPoolResourceInner object itself.
     */
    public WorkerPoolResourceInner withWorkerSizeId(Integer workerSizeId) {
        this.workerSizeId = workerSizeId;
        return this;
    }

    /**
     * Get shared or dedicated app hosting. Possible values include: 'Shared', 'Dedicated', 'Dynamic'.
     *
     * @return the computeMode value
     */
    public ComputeModeOptions computeMode() {
        return this.computeMode;
    }

    /**
     * Set shared or dedicated app hosting. Possible values include: 'Shared', 'Dedicated', 'Dynamic'.
     *
     * @param computeMode the computeMode value to set
     * @return the WorkerPoolResourceInner object itself.
     */
    public WorkerPoolResourceInner withComputeMode(ComputeModeOptions computeMode) {
        this.computeMode = computeMode;
        return this;
    }

    /**
     * Get vM size of the worker pool instances.
     *
     * @return the workerSize value
     */
    public String workerSize() {
        return this.workerSize;
    }

    /**
     * Set vM size of the worker pool instances.
     *
     * @param workerSize the workerSize value to set
     * @return the WorkerPoolResourceInner object itself.
     */
    public WorkerPoolResourceInner withWorkerSize(String workerSize) {
        this.workerSize = workerSize;
        return this;
    }

    /**
     * Get number of instances in the worker pool.
     *
     * @return the workerCount value
     */
    public Integer workerCount() {
        return this.workerCount;
    }

    /**
     * Set number of instances in the worker pool.
     *
     * @param workerCount the workerCount value to set
     * @return the WorkerPoolResourceInner object itself.
     */
    public WorkerPoolResourceInner withWorkerCount(Integer workerCount) {
        this.workerCount = workerCount;
        return this;
    }

    /**
     * Get names of all instances in the worker pool (read only).
     *
     * @return the instanceNames value
     */
    public List<String> instanceNames() {
        return this.instanceNames;
    }

    /**
     * Get the sku value.
     *
     * @return the sku value
     */
    public SkuDescription sku() {
        return this.sku;
    }

    /**
     * Set the sku value.
     *
     * @param sku the sku value to set
     * @return the WorkerPoolResourceInner object itself.
     */
    public WorkerPoolResourceInner withSku(SkuDescription sku) {
        this.sku = sku;
        return this;
    }

}
