/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.ApplicationLogsConfig;
import com.microsoft.azure.management.appservice.AzureBlobStorageApplicationLogsConfig;
import com.microsoft.azure.management.appservice.AzureBlobStorageHttpLogsConfig;
import com.microsoft.azure.management.appservice.EnabledConfig;
import com.microsoft.azure.management.appservice.FileSystemApplicationLogsConfig;
import com.microsoft.azure.management.appservice.FileSystemHttpLogsConfig;
import com.microsoft.azure.management.appservice.HttpLogsConfig;
import com.microsoft.azure.management.appservice.LogLevel;
import com.microsoft.azure.management.appservice.WebAppBase;
import com.microsoft.azure.management.appservice.WebAppDiagnosticLogs;
import com.microsoft.azure.management.appservice.implementation.SiteLogsConfigInner;
import com.microsoft.azure.management.appservice.implementation.WebAppBaseImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
class WebAppDiagnosticLogsImpl<FluentT extends WebAppBase, FluentImplT extends WebAppBaseImpl<FluentT, FluentImplT>>
extends IndexableWrapperImpl<SiteLogsConfigInner>
implements WebAppDiagnosticLogs,
WebAppDiagnosticLogs.Definition<WebAppBase.DefinitionStages.WithCreate<FluentT>>,
WebAppDiagnosticLogs.UpdateDefinition<WebAppBase.Update<FluentT>> {
    private final WebAppBaseImpl<FluentT, FluentImplT> parent;
    private LogLevel applicationLogLevel = null;

    WebAppDiagnosticLogsImpl(SiteLogsConfigInner inner, WebAppBaseImpl<FluentT, FluentImplT> parent) {
        super((Object)inner);
        if (inner.applicationLogs() != null) {
            inner.applicationLogs().withAzureTableStorage(null);
        }
        this.parent = parent;
    }

    @Override
    public LogLevel applicationLoggingFileSystemLogLevel() {
        if (((SiteLogsConfigInner)((Object)this.inner())).applicationLogs() == null || ((SiteLogsConfigInner)((Object)this.inner())).applicationLogs().fileSystem() == null || ((SiteLogsConfigInner)((Object)this.inner())).applicationLogs().fileSystem().level() == null) {
            return LogLevel.OFF;
        }
        return ((SiteLogsConfigInner)((Object)this.inner())).applicationLogs().fileSystem().level();
    }

    @Override
    public String applicationLoggingStorageBlobContainer() {
        if (((SiteLogsConfigInner)((Object)this.inner())).applicationLogs() == null || ((SiteLogsConfigInner)((Object)this.inner())).applicationLogs().azureBlobStorage() == null) {
            return null;
        }
        return ((SiteLogsConfigInner)((Object)this.inner())).applicationLogs().azureBlobStorage().sasUrl();
    }

    @Override
    public LogLevel applicationLoggingStorageBlobLogLevel() {
        if (((SiteLogsConfigInner)((Object)this.inner())).applicationLogs() == null || ((SiteLogsConfigInner)((Object)this.inner())).applicationLogs().azureBlobStorage() == null || ((SiteLogsConfigInner)((Object)this.inner())).applicationLogs().azureBlobStorage().level() == null) {
            return LogLevel.OFF;
        }
        return ((SiteLogsConfigInner)((Object)this.inner())).applicationLogs().azureBlobStorage().level();
    }

    @Override
    public int applicationLoggingStorageBlobRetentionDays() {
        if (((SiteLogsConfigInner)((Object)this.inner())).applicationLogs() == null || ((SiteLogsConfigInner)((Object)this.inner())).applicationLogs().azureBlobStorage() == null) {
            return 0;
        }
        return Utils.toPrimitiveInt((Integer)((SiteLogsConfigInner)((Object)this.inner())).applicationLogs().azureBlobStorage().retentionInDays());
    }

    @Override
    public int webServerLoggingFileSystemQuotaInMB() {
        if (((SiteLogsConfigInner)((Object)this.inner())).httpLogs() == null || ((SiteLogsConfigInner)((Object)this.inner())).httpLogs().fileSystem() == null) {
            return 0;
        }
        return Utils.toPrimitiveInt((Integer)((SiteLogsConfigInner)((Object)this.inner())).httpLogs().fileSystem().retentionInMb());
    }

    @Override
    public int webServerLoggingFileSystemRetentionDays() {
        if (((SiteLogsConfigInner)((Object)this.inner())).httpLogs() == null || ((SiteLogsConfigInner)((Object)this.inner())).httpLogs().fileSystem() == null) {
            return 0;
        }
        return Utils.toPrimitiveInt((Integer)((SiteLogsConfigInner)((Object)this.inner())).httpLogs().fileSystem().retentionInDays());
    }

    @Override
    public int webServerLoggingStorageBlobRetentionDays() {
        if (((SiteLogsConfigInner)((Object)this.inner())).httpLogs() == null || ((SiteLogsConfigInner)((Object)this.inner())).httpLogs().azureBlobStorage() == null) {
            return 0;
        }
        return Utils.toPrimitiveInt((Integer)((SiteLogsConfigInner)((Object)this.inner())).httpLogs().azureBlobStorage().retentionInDays());
    }

    @Override
    public String webServerLoggingStorageBlobContainer() {
        if (((SiteLogsConfigInner)((Object)this.inner())).httpLogs() == null || ((SiteLogsConfigInner)((Object)this.inner())).httpLogs().azureBlobStorage() == null) {
            return null;
        }
        return ((SiteLogsConfigInner)((Object)this.inner())).httpLogs().azureBlobStorage().sasUrl();
    }

    @Override
    public boolean failedRequestsTracing() {
        return ((SiteLogsConfigInner)((Object)this.inner())).failedRequestsTracing() != null && Utils.toPrimitiveBoolean((Boolean)((SiteLogsConfigInner)((Object)this.inner())).failedRequestsTracing().enabled());
    }

    @Override
    public boolean detailedErrorMessages() {
        return ((SiteLogsConfigInner)((Object)this.inner())).detailedErrorMessages() != null && Utils.toPrimitiveBoolean((Boolean)((SiteLogsConfigInner)((Object)this.inner())).detailedErrorMessages().enabled());
    }

    public FluentImplT attach() {
        this.parent.withDiagnosticLogs(this);
        return (FluentImplT)this.parent();
    }

    public FluentImplT parent() {
        this.parent.withDiagnosticLogs(this);
        return (FluentImplT)this.parent;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withApplicationLogging() {
        ((SiteLogsConfigInner)((Object)this.inner())).withApplicationLogs(new ApplicationLogsConfig());
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withoutApplicationLogging() {
        this.withoutApplicationLogsStoredOnFileSystem();
        this.withoutApplicationLogsStoredOnStorageBlob();
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withWebServerLogging() {
        ((SiteLogsConfigInner)((Object)this.inner())).withHttpLogs(new HttpLogsConfig());
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withoutWebServerLogging() {
        this.withoutWebServerLogsStoredOnFileSystem();
        this.withoutWebServerLogsStoredOnStorageBlob();
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withDetailedErrorMessages(boolean enabled) {
        ((SiteLogsConfigInner)((Object)this.inner())).withDetailedErrorMessages(new EnabledConfig().withEnabled(enabled));
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withFailedRequestTracing(boolean enabled) {
        ((SiteLogsConfigInner)((Object)this.inner())).withFailedRequestsTracing(new EnabledConfig().withEnabled(enabled));
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withApplicationLogsStoredOnFileSystem() {
        if (((SiteLogsConfigInner)((Object)this.inner())).applicationLogs() != null) {
            ((SiteLogsConfigInner)((Object)this.inner())).applicationLogs().withFileSystem(new FileSystemApplicationLogsConfig().withLevel(this.applicationLogLevel));
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withApplicationLogsStoredOnStorageBlob(String containerSasUrl) {
        if (((SiteLogsConfigInner)((Object)this.inner())).applicationLogs() != null) {
            ((SiteLogsConfigInner)((Object)this.inner())).applicationLogs().withAzureBlobStorage(new AzureBlobStorageApplicationLogsConfig().withLevel(this.applicationLogLevel).withSasUrl(containerSasUrl));
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withWebServerLogsStoredOnFileSystem() {
        if (((SiteLogsConfigInner)((Object)this.inner())).httpLogs() != null) {
            ((SiteLogsConfigInner)((Object)this.inner())).httpLogs().withFileSystem(new FileSystemHttpLogsConfig().withEnabled(true));
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withWebServerLogsStoredOnStorageBlob(String containerSasUrl) {
        if (((SiteLogsConfigInner)((Object)this.inner())).httpLogs() != null) {
            ((SiteLogsConfigInner)((Object)this.inner())).httpLogs().withAzureBlobStorage(new AzureBlobStorageHttpLogsConfig().withEnabled(true).withSasUrl(containerSasUrl));
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withoutWebServerLogsStoredOnFileSystem() {
        if (((SiteLogsConfigInner)((Object)this.inner())).httpLogs() != null && ((SiteLogsConfigInner)((Object)this.inner())).httpLogs().fileSystem() != null) {
            ((SiteLogsConfigInner)((Object)this.inner())).httpLogs().fileSystem().withEnabled(false);
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withoutWebServerLogsStoredOnStorageBlob() {
        if (((SiteLogsConfigInner)((Object)this.inner())).httpLogs() != null && ((SiteLogsConfigInner)((Object)this.inner())).httpLogs().azureBlobStorage() != null) {
            ((SiteLogsConfigInner)((Object)this.inner())).httpLogs().azureBlobStorage().withEnabled(false);
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withLogLevel(LogLevel logLevel) {
        this.applicationLogLevel = logLevel;
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withWebServerFileSystemQuotaInMB(int quotaInMB) {
        if (((SiteLogsConfigInner)((Object)this.inner())).httpLogs() != null && ((SiteLogsConfigInner)((Object)this.inner())).httpLogs().fileSystem() != null && ((SiteLogsConfigInner)((Object)this.inner())).httpLogs().fileSystem().enabled().booleanValue()) {
            ((SiteLogsConfigInner)((Object)this.inner())).httpLogs().fileSystem().withRetentionInMb(quotaInMB);
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withLogRetentionDays(int retentionDays) {
        if (((SiteLogsConfigInner)((Object)this.inner())).httpLogs() != null && ((SiteLogsConfigInner)((Object)this.inner())).httpLogs().fileSystem() != null && ((SiteLogsConfigInner)((Object)this.inner())).httpLogs().fileSystem().enabled().booleanValue()) {
            ((SiteLogsConfigInner)((Object)this.inner())).httpLogs().fileSystem().withRetentionInDays(retentionDays);
        }
        if (((SiteLogsConfigInner)((Object)this.inner())).httpLogs() != null && ((SiteLogsConfigInner)((Object)this.inner())).httpLogs().azureBlobStorage() != null && ((SiteLogsConfigInner)((Object)this.inner())).httpLogs().azureBlobStorage().enabled().booleanValue()) {
            ((SiteLogsConfigInner)((Object)this.inner())).httpLogs().azureBlobStorage().withRetentionInDays(retentionDays);
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withUnlimitedLogRetentionDays() {
        if (((SiteLogsConfigInner)((Object)this.inner())).httpLogs() != null && ((SiteLogsConfigInner)((Object)this.inner())).httpLogs().fileSystem() != null && ((SiteLogsConfigInner)((Object)this.inner())).httpLogs().fileSystem().enabled().booleanValue()) {
            ((SiteLogsConfigInner)((Object)this.inner())).httpLogs().fileSystem().withRetentionInDays(0);
        }
        if (((SiteLogsConfigInner)((Object)this.inner())).httpLogs() != null && ((SiteLogsConfigInner)((Object)this.inner())).httpLogs().azureBlobStorage() != null && ((SiteLogsConfigInner)((Object)this.inner())).httpLogs().fileSystem().enabled().booleanValue()) {
            ((SiteLogsConfigInner)((Object)this.inner())).httpLogs().azureBlobStorage().withRetentionInDays(0);
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withoutApplicationLogsStoredOnFileSystem() {
        if (((SiteLogsConfigInner)((Object)this.inner())).applicationLogs() != null && ((SiteLogsConfigInner)((Object)this.inner())).applicationLogs().fileSystem() != null) {
            ((SiteLogsConfigInner)((Object)this.inner())).applicationLogs().fileSystem().withLevel(LogLevel.OFF);
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withoutApplicationLogsStoredOnStorageBlob() {
        if (((SiteLogsConfigInner)((Object)this.inner())).applicationLogs() != null && ((SiteLogsConfigInner)((Object)this.inner())).applicationLogs().azureBlobStorage() != null) {
            ((SiteLogsConfigInner)((Object)this.inner())).applicationLogs().azureBlobStorage().withLevel(LogLevel.OFF);
        }
        return this;
    }
}

