/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Link to an application package inside the batch account.
 */
public class ApplicationPackageReference {
    /**
     * The ID of the application package to install. This must be inside the
     * same batch account as the pool. This can either be a reference to a
     * specific version or the default version if one exists.
     */
    @JsonProperty(value = "id", required = true)
    private String id;

    /**
     * The version of the application to deploy. If omitted, the default
     * version is deployed.
     * If this is omitted, and no default version is specified for this
     * application, the request fails with the error code
     * InvalidApplicationPackageReferences. If you are calling the REST API
     * directly, the HTTP status code is 409.
     */
    @JsonProperty(value = "version")
    private String version;

    /**
     * Get the id value.
     *
     * @return the id value
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id value.
     *
     * @param id the id value to set
     * @return the ApplicationPackageReference object itself.
     */
    public ApplicationPackageReference withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the version value.
     *
     * @return the version value
     */
    public String version() {
        return this.version;
    }

    /**
     * Set the version value.
     *
     * @param version the version value to set
     * @return the ApplicationPackageReference object itself.
     */
    public ApplicationPackageReference withVersion(String version) {
        this.version = version;
        return this;
    }

}
