/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Specifies the parameters for the auto user that runs a task on the Batch
 * service.
 */
public class AutoUserSpecification {
    /**
     * The scope for the auto user.
     * pool - specifies that the task runs as the common auto user account
     * which is created on every node in a pool. task - specifies that the
     * service should create a new user for the task. The default value is
     * task. Possible values include: 'Task', 'Pool'.
     */
    @JsonProperty(value = "scope")
    private AutoUserScope scope;

    /**
     * The elevation level of the auto user.
     * nonAdmin - The auto user is a standard user without elevated access.
     * admin - The auto user is a user with elevated access and operates with
     * full Administrator permissions. The default value is nonAdmin. Possible
     * values include: 'NonAdmin', 'Admin'.
     */
    @JsonProperty(value = "elevationLevel")
    private ElevationLevel elevationLevel;

    /**
     * Get the scope value.
     *
     * @return the scope value
     */
    public AutoUserScope scope() {
        return this.scope;
    }

    /**
     * Set the scope value.
     *
     * @param scope the scope value to set
     * @return the AutoUserSpecification object itself.
     */
    public AutoUserSpecification withScope(AutoUserScope scope) {
        this.scope = scope;
        return this;
    }

    /**
     * Get the elevationLevel value.
     *
     * @return the elevationLevel value
     */
    public ElevationLevel elevationLevel() {
        return this.elevationLevel;
    }

    /**
     * Set the elevationLevel value.
     *
     * @param elevationLevel the elevationLevel value to set
     * @return the AutoUserSpecification object itself.
     */
    public AutoUserSpecification withElevationLevel(ElevationLevel elevationLevel) {
        this.elevationLevel = elevationLevel;
        return this;
    }

}
