/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for CertificateVisibility.
 */
public enum CertificateVisibility {
    /** Enum value StartTask. */
    START_TASK("StartTask"),

    /** Enum value Task. */
    TASK("Task"),

    /** Enum value RemoteUser. */
    REMOTE_USER("RemoteUser");

    /** The actual serialized value for a CertificateVisibility instance. */
    private String value;

    CertificateVisibility(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a CertificateVisibility instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed CertificateVisibility object, or null if unable to parse.
     */
    @JsonCreator
    public static CertificateVisibility fromString(String value) {
        CertificateVisibility[] items = CertificateVisibility.values();
        for (CertificateVisibility item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
