/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A inbound NAT pool that can be used to address specific ports on compute
 * nodes in a Batch pool externally.
 */
public class InboundNatPool {
    /**
     * The name of the endpoint.
     * The name must be unique within a Batch pool, can contain letters,
     * numbers, underscores, periods, and hyphens. Names must start with a
     * letter or number, must end with a letter, number, or underscore, and
     * cannot exceed 77 characters.  If any invalid values are provided the
     * request fails with HTTP status code 400.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /**
     * The protocol of the endpoint.
     * Possible values include: 'TCP', 'UDP'.
     */
    @JsonProperty(value = "protocol", required = true)
    private InboundEndpointProtocol protocol;

    /**
     * The port number on the compute node.
     * This must be unique within a Batch pool. Acceptable values are between 1
     * and 65535 except for 22, 3389, 29876 and 29877 as these are reserved. If
     * any reserved values are provided the request fails with HTTP status code
     * 400.
     */
    @JsonProperty(value = "backendPort", required = true)
    private int backendPort;

    /**
     * The first port number in the range of external ports that will be used
     * to provide inbound access to the backendPort on individual compute
     * nodes.
     * Acceptable values range between 1 and 65534 except ports from 50000 to
     * 55000 which are reserved. All ranges within a pool must be distinct and
     * cannot overlap. If any reserved or overlapping values are provided the
     * request fails with HTTP status code 400.
     */
    @JsonProperty(value = "frontendPortRangeStart", required = true)
    private int frontendPortRangeStart;

    /**
     * The last port number in the range of external ports that will be used to
     * provide inbound access to the backendPort on individual compute nodes.
     * Acceptable values range between 1 and 65534 except ports from 50000 to
     * 55000 which are reserved by the Batch service. All ranges within a pool
     * must be distinct and cannot overlap. If any reserved or overlapping
     * values are provided the request fails with HTTP status code 400.
     */
    @JsonProperty(value = "frontendPortRangeEnd", required = true)
    private int frontendPortRangeEnd;

    /**
     * A list of network security group rules that will be applied to the
     * endpoint.
     * The maximum number of rules that can be specified across all the
     * endpoints on a Batch pool is 25. If no network security group rules are
     * specified, a default rule will be created to allow inbound access to the
     * specified backendPort. If the maximum number of network security group
     * rules is exceeded the request fails with HTTP status code 400.
     */
    @JsonProperty(value = "networkSecurityGroupRules")
    private List<NetworkSecurityGroupRule> networkSecurityGroupRules;

    /**
     * Get the name value.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name value.
     *
     * @param name the name value to set
     * @return the InboundNatPool object itself.
     */
    public InboundNatPool withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the protocol value.
     *
     * @return the protocol value
     */
    public InboundEndpointProtocol protocol() {
        return this.protocol;
    }

    /**
     * Set the protocol value.
     *
     * @param protocol the protocol value to set
     * @return the InboundNatPool object itself.
     */
    public InboundNatPool withProtocol(InboundEndpointProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    /**
     * Get the backendPort value.
     *
     * @return the backendPort value
     */
    public int backendPort() {
        return this.backendPort;
    }

    /**
     * Set the backendPort value.
     *
     * @param backendPort the backendPort value to set
     * @return the InboundNatPool object itself.
     */
    public InboundNatPool withBackendPort(int backendPort) {
        this.backendPort = backendPort;
        return this;
    }

    /**
     * Get the frontendPortRangeStart value.
     *
     * @return the frontendPortRangeStart value
     */
    public int frontendPortRangeStart() {
        return this.frontendPortRangeStart;
    }

    /**
     * Set the frontendPortRangeStart value.
     *
     * @param frontendPortRangeStart the frontendPortRangeStart value to set
     * @return the InboundNatPool object itself.
     */
    public InboundNatPool withFrontendPortRangeStart(int frontendPortRangeStart) {
        this.frontendPortRangeStart = frontendPortRangeStart;
        return this;
    }

    /**
     * Get the frontendPortRangeEnd value.
     *
     * @return the frontendPortRangeEnd value
     */
    public int frontendPortRangeEnd() {
        return this.frontendPortRangeEnd;
    }

    /**
     * Set the frontendPortRangeEnd value.
     *
     * @param frontendPortRangeEnd the frontendPortRangeEnd value to set
     * @return the InboundNatPool object itself.
     */
    public InboundNatPool withFrontendPortRangeEnd(int frontendPortRangeEnd) {
        this.frontendPortRangeEnd = frontendPortRangeEnd;
        return this;
    }

    /**
     * Get the networkSecurityGroupRules value.
     *
     * @return the networkSecurityGroupRules value
     */
    public List<NetworkSecurityGroupRule> networkSecurityGroupRules() {
        return this.networkSecurityGroupRules;
    }

    /**
     * Set the networkSecurityGroupRules value.
     *
     * @param networkSecurityGroupRules the networkSecurityGroupRules value to set
     * @return the InboundNatPool object itself.
     */
    public InboundNatPool withNetworkSecurityGroupRules(List<NetworkSecurityGroupRule> networkSecurityGroupRules) {
        this.networkSecurityGroupRules = networkSecurityGroupRules;
        return this;
    }

}
