/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Settings for the operating system disk of the virtual machine.
 */
public class OSDisk {
    /**
     * The type of caching to be enabled for the data disks. none - The caching
     * mode for the disk is not enabled. readOnly - The caching mode for the
     * disk is read only. readWrite - The caching mode for the disk is read and
     * write.
     * Default value is none. Possible values include: 'None', 'ReadOnly',
     * 'ReadWrite'.
     */
    @JsonProperty(value = "caching")
    private CachingType caching;

    /**
     * Get the caching value.
     *
     * @return the caching value
     */
    public CachingType caching() {
        return this.caching;
    }

    /**
     * Set the caching value.
     *
     * @param caching the caching value to set
     * @return the OSDisk object itself.
     */
    public OSDisk withCaching(CachingType caching) {
        this.caching = caching;
        return this;
    }

}
