/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch.implementation;

import com.microsoft.azure.management.batch.CertificateFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.ProxyResource;

/**
 * Contains information about a certificate.
 */
@JsonFlatten
public class CertificateCreateOrUpdateParametersInner extends ProxyResource {
    /**
     * The algorithm of the certificate thumbprint.
     * This must match the first portion of the certificate name. Currently
     * required to be 'SHA1'.
     */
    @JsonProperty(value = "properties.thumbprintAlgorithm")
    private String thumbprintAlgorithm;

    /**
     * The thumbprint of the certificate.
     * This must match the thumbprint from the name.
     */
    @JsonProperty(value = "properties.thumbprint")
    private String thumbprint;

    /**
     * The format of the certificate - either Pfx or Cer. If omitted, the
     * default is Pfx. Possible values include: 'Pfx', 'Cer'.
     */
    @JsonProperty(value = "properties.format")
    private CertificateFormat format;

    /**
     * The base64-encoded contents of the certificate.
     * The maximum size is 10KB.
     */
    @JsonProperty(value = "properties.data", required = true)
    private String data;

    /**
     * The password to access the certificate's private key.
     * This is required if the certificate format is pfx and must be omitted if
     * the certificate format is cer.
     */
    @JsonProperty(value = "properties.password")
    private String password;

    /**
     * The ETag of the resource, used for concurrency statements.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /**
     * Get the thumbprintAlgorithm value.
     *
     * @return the thumbprintAlgorithm value
     */
    public String thumbprintAlgorithm() {
        return this.thumbprintAlgorithm;
    }

    /**
     * Set the thumbprintAlgorithm value.
     *
     * @param thumbprintAlgorithm the thumbprintAlgorithm value to set
     * @return the CertificateCreateOrUpdateParametersInner object itself.
     */
    public CertificateCreateOrUpdateParametersInner withThumbprintAlgorithm(String thumbprintAlgorithm) {
        this.thumbprintAlgorithm = thumbprintAlgorithm;
        return this;
    }

    /**
     * Get the thumbprint value.
     *
     * @return the thumbprint value
     */
    public String thumbprint() {
        return this.thumbprint;
    }

    /**
     * Set the thumbprint value.
     *
     * @param thumbprint the thumbprint value to set
     * @return the CertificateCreateOrUpdateParametersInner object itself.
     */
    public CertificateCreateOrUpdateParametersInner withThumbprint(String thumbprint) {
        this.thumbprint = thumbprint;
        return this;
    }

    /**
     * Get the format value.
     *
     * @return the format value
     */
    public CertificateFormat format() {
        return this.format;
    }

    /**
     * Set the format value.
     *
     * @param format the format value to set
     * @return the CertificateCreateOrUpdateParametersInner object itself.
     */
    public CertificateCreateOrUpdateParametersInner withFormat(CertificateFormat format) {
        this.format = format;
        return this;
    }

    /**
     * Get the data value.
     *
     * @return the data value
     */
    public String data() {
        return this.data;
    }

    /**
     * Set the data value.
     *
     * @param data the data value to set
     * @return the CertificateCreateOrUpdateParametersInner object itself.
     */
    public CertificateCreateOrUpdateParametersInner withData(String data) {
        this.data = data;
        return this;
    }

    /**
     * Get the password value.
     *
     * @return the password value
     */
    public String password() {
        return this.password;
    }

    /**
     * Set the password value.
     *
     * @param password the password value to set
     * @return the CertificateCreateOrUpdateParametersInner object itself.
     */
    public CertificateCreateOrUpdateParametersInner withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * Get the etag value.
     *
     * @return the etag value
     */
    public String etag() {
        return this.etag;
    }

}
