/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batch.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.batch.Application;
import com.microsoft.azure.management.batch.ApplicationCreateParameters;
import com.microsoft.azure.management.batch.ApplicationPackage;
import com.microsoft.azure.management.batch.ApplicationUpdateParameters;
import com.microsoft.azure.management.batch.BatchAccount;
import com.microsoft.azure.management.batch.implementation.ApplicationInner;
import com.microsoft.azure.management.batch.implementation.ApplicationPackageImpl;
import com.microsoft.azure.management.batch.implementation.ApplicationPackagesImpl;
import com.microsoft.azure.management.batch.implementation.BatchAccountImpl;
import com.microsoft.azure.management.batch.implementation.BatchManagementClientImpl;
import com.microsoft.azure.management.batch.implementation.BatchManager;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.RXMapper;
import java.util.List;
import java.util.Map;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class ApplicationImpl
extends ExternalChildResourceImpl<Application, ApplicationInner, BatchAccountImpl, BatchAccount>
implements Application,
Application.Definition<BatchAccount.DefinitionStages.WithApplicationAndStorage>,
Application.UpdateDefinition<BatchAccount.Update>,
Application.Update {
    private final ApplicationPackagesImpl applicationPackages = new ApplicationPackagesImpl(this);

    protected ApplicationImpl(String name, BatchAccountImpl batchAccount, ApplicationInner inner) {
        super(name, (Object)batchAccount, (Object)inner);
        this.applicationPackages.enableCommitMode();
    }

    public String id() {
        return ((ApplicationInner)this.inner()).id();
    }

    @Override
    public String displayName() {
        return ((ApplicationInner)this.inner()).displayName();
    }

    @Override
    public Map<String, ApplicationPackage> applicationPackages() {
        return this.applicationPackages.asMap();
    }

    @Override
    public boolean updatesAllowed() {
        return ((ApplicationInner)this.inner()).allowUpdates();
    }

    @Override
    public String defaultVersion() {
        return ((ApplicationInner)this.inner()).defaultVersion();
    }

    public Observable<Application> createResourceAsync() {
        final ApplicationImpl self = this;
        ApplicationCreateParameters createParameter = new ApplicationCreateParameters();
        createParameter.withDisplayName(((ApplicationInner)this.inner()).displayName());
        createParameter.withAllowUpdates(((ApplicationInner)this.inner()).allowUpdates());
        return ((BatchManagementClientImpl)((Object)((BatchManager)((BatchAccountImpl)this.parent()).manager()).inner())).applications().createAsync(((BatchAccountImpl)this.parent()).resourceGroupName(), ((BatchAccountImpl)this.parent()).name(), this.name(), createParameter).map((Func1)new Func1<ApplicationInner, Application>(){

            public Application call(ApplicationInner inner) {
                self.setInner(inner);
                return self;
            }
        }).flatMap((Func1)new Func1<Application, Observable<? extends Application>>(){

            public Observable<? extends Application> call(Application application) {
                return self.applicationPackages.commitAndGetAllAsync().map((Func1)new Func1<List<ApplicationPackageImpl>, Application>(){

                    public Application call(List<ApplicationPackageImpl> applications) {
                        return self;
                    }
                });
            }
        });
    }

    public Observable<Application> updateResourceAsync() {
        final ApplicationImpl self = this;
        ApplicationUpdateParameters updateParameter = new ApplicationUpdateParameters();
        updateParameter.withDisplayName(((ApplicationInner)this.inner()).displayName());
        updateParameter.withAllowUpdates(((ApplicationInner)this.inner()).allowUpdates());
        return RXMapper.map(((BatchManagementClientImpl)((Object)((BatchManager)((BatchAccountImpl)this.parent()).manager()).inner())).applications().updateAsync(((BatchAccountImpl)this.parent()).resourceGroupName(), ((BatchAccountImpl)this.parent()).name(), this.name(), updateParameter), (Object)self).flatMap((Func1)new Func1<Application, Observable<? extends Application>>(){

            public Observable<? extends Application> call(Application application) {
                return self.applicationPackages.commitAndGetAllAsync().map((Func1)new Func1<List<ApplicationPackageImpl>, Application>(){

                    public Application call(List<ApplicationPackageImpl> applications) {
                        return self;
                    }
                });
            }
        });
    }

    public Observable<Void> deleteResourceAsync() {
        return ((BatchManagementClientImpl)((Object)((BatchManager)((BatchAccountImpl)this.parent()).manager()).inner())).applications().deleteAsync(((BatchAccountImpl)this.parent()).resourceGroupName(), ((BatchAccountImpl)this.parent()).name(), this.name());
    }

    public Observable<Application> refreshAsync() {
        return super.refreshAsync().map((Func1)new Func1<Application, Application>(){

            public Application call(Application application) {
                ApplicationImpl impl = (ApplicationImpl)application;
                impl.applicationPackages.refresh();
                return impl;
            }
        });
    }

    protected Observable<ApplicationInner> getInnerAsync() {
        return ((BatchManagementClientImpl)((Object)((BatchManager)((BatchAccountImpl)this.parent()).manager()).inner())).applications().getAsync(((BatchAccountImpl)this.parent()).resourceGroupName(), ((BatchAccountImpl)this.parent()).name(), ((ApplicationInner)this.inner()).id());
    }

    public BatchAccountImpl attach() {
        return ((BatchAccountImpl)this.parent()).withApplication(this);
    }

    @Override
    public ApplicationImpl withAllowUpdates(boolean allowUpdates) {
        ((ApplicationInner)this.inner()).withAllowUpdates(allowUpdates);
        return this;
    }

    @Override
    public ApplicationImpl withDisplayName(String displayName) {
        ((ApplicationInner)this.inner()).withDisplayName(displayName);
        return this;
    }

    protected static ApplicationImpl newApplication(String name, BatchAccountImpl parent) {
        ApplicationInner inner = new ApplicationInner();
        inner.withId(name);
        ApplicationImpl applicationImpl = new ApplicationImpl(name, parent, inner);
        return applicationImpl;
    }

    @Override
    public Application.Update withoutApplicationPackage(String applicationPackageName) {
        this.applicationPackages.remove(applicationPackageName);
        return this;
    }

    ApplicationImpl withApplicationPackage(ApplicationPackageImpl applicationPackage) {
        this.applicationPackages.addApplicationPackage(applicationPackage);
        return this;
    }

    @Override
    public ApplicationImpl defineNewApplicationPackage(String applicationPackageName) {
        this.withApplicationPackage(this.applicationPackages.define(applicationPackageName));
        return this;
    }
}

