/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The CertificateBaseProperties model.
 */
public class CertificateBaseProperties {
    /**
     * The algorithm of the certificate thumbprint.
     * This must match the first portion of the certificate name. Currently
     * required to be 'SHA1'.
     */
    @JsonProperty(value = "thumbprintAlgorithm")
    private String thumbprintAlgorithm;

    /**
     * The thumbprint of the certificate.
     * This must match the thumbprint from the name.
     */
    @JsonProperty(value = "thumbprint")
    private String thumbprint;

    /**
     * The format of the certificate - either Pfx or Cer. If omitted, the
     * default is Pfx. Possible values include: 'Pfx', 'Cer'.
     */
    @JsonProperty(value = "format")
    private CertificateFormat format;

    /**
     * Get the thumbprintAlgorithm value.
     *
     * @return the thumbprintAlgorithm value
     */
    public String thumbprintAlgorithm() {
        return this.thumbprintAlgorithm;
    }

    /**
     * Set the thumbprintAlgorithm value.
     *
     * @param thumbprintAlgorithm the thumbprintAlgorithm value to set
     * @return the CertificateBaseProperties object itself.
     */
    public CertificateBaseProperties withThumbprintAlgorithm(String thumbprintAlgorithm) {
        this.thumbprintAlgorithm = thumbprintAlgorithm;
        return this;
    }

    /**
     * Get the thumbprint value.
     *
     * @return the thumbprint value
     */
    public String thumbprint() {
        return this.thumbprint;
    }

    /**
     * Set the thumbprint value.
     *
     * @param thumbprint the thumbprint value to set
     * @return the CertificateBaseProperties object itself.
     */
    public CertificateBaseProperties withThumbprint(String thumbprint) {
        this.thumbprint = thumbprint;
        return this;
    }

    /**
     * Get the format value.
     *
     * @return the format value
     */
    public CertificateFormat format() {
        return this.format;
    }

    /**
     * Set the format value.
     *
     * @param format the format value to set
     * @return the CertificateBaseProperties object itself.
     */
    public CertificateBaseProperties withFormat(CertificateFormat format) {
        this.format = format;
        return this;
    }

}
