/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A reference to a certificate to be installed on compute nodes in a pool.
 * This must exist inside the same account as the pool.
 */
public class CertificateReference {
    /**
     * The fully qualified ID of the certificate to install on the pool. This
     * must be inside the same batch account as the pool.
     */
    @JsonProperty(value = "id", required = true)
    private String id;

    /**
     * The location of the certificate store on the compute node into which to
     * install the certificate.
     * The default value is currentUser. This property is applicable only for
     * pools configured with Windows nodes (that is, created with
     * cloudServiceConfiguration, or with virtualMachineConfiguration using a
     * Windows image reference). For Linux compute nodes, the certificates are
     * stored in a directory inside the task working directory and an
     * environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task
     * to query for this location. For certificates with visibility of
     * 'remoteUser', a 'certs' directory is created in the user's home
     * directory (e.g., /home/{user-name}/certs) and certificates are placed in
     * that directory. Possible values include: 'CurrentUser', 'LocalMachine'.
     */
    @JsonProperty(value = "storeLocation")
    private CertificateStoreLocation storeLocation;

    /**
     * The name of the certificate store on the compute node into which to
     * install the certificate.
     * This property is applicable only for pools configured with Windows nodes
     * (that is, created with cloudServiceConfiguration, or with
     * virtualMachineConfiguration using a Windows image reference). Common
     * store names include: My, Root, CA, Trust, Disallowed, TrustedPeople,
     * TrustedPublisher, AuthRoot, AddressBook, but any custom store name can
     * also be used. The default value is My.
     */
    @JsonProperty(value = "storeName")
    private String storeName;

    /**
     * Which user accounts on the compute node should have access to the
     * private data of the certificate.
     * Values are:
     *
     * starttask - The user account under which the start task is run.
     * task - The accounts under which job tasks are run.
     * remoteuser - The accounts under which users remotely access the node.
     *
     * You can specify more than one visibility in this collection. The default
     * is all accounts.
     */
    @JsonProperty(value = "visibility")
    private List<CertificateVisibility> visibility;

    /**
     * Get the id value.
     *
     * @return the id value
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id value.
     *
     * @param id the id value to set
     * @return the CertificateReference object itself.
     */
    public CertificateReference withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the storeLocation value.
     *
     * @return the storeLocation value
     */
    public CertificateStoreLocation storeLocation() {
        return this.storeLocation;
    }

    /**
     * Set the storeLocation value.
     *
     * @param storeLocation the storeLocation value to set
     * @return the CertificateReference object itself.
     */
    public CertificateReference withStoreLocation(CertificateStoreLocation storeLocation) {
        this.storeLocation = storeLocation;
        return this;
    }

    /**
     * Get the storeName value.
     *
     * @return the storeName value
     */
    public String storeName() {
        return this.storeName;
    }

    /**
     * Set the storeName value.
     *
     * @param storeName the storeName value to set
     * @return the CertificateReference object itself.
     */
    public CertificateReference withStoreName(String storeName) {
        this.storeName = storeName;
        return this;
    }

    /**
     * Get the visibility value.
     *
     * @return the visibility value
     */
    public List<CertificateVisibility> visibility() {
        return this.visibility;
    }

    /**
     * Set the visibility value.
     *
     * @param visibility the visibility value to set
     * @return the CertificateReference object itself.
     */
    public CertificateReference withVisibility(List<CertificateVisibility> visibility) {
        this.visibility = visibility;
        return this;
    }

}
