/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batch.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.batch.AccountKeyType;
import com.microsoft.azure.management.batch.Application;
import com.microsoft.azure.management.batch.AutoStorageBaseProperties;
import com.microsoft.azure.management.batch.AutoStorageProperties;
import com.microsoft.azure.management.batch.BatchAccount;
import com.microsoft.azure.management.batch.BatchAccountKeys;
import com.microsoft.azure.management.batch.ProvisioningState;
import com.microsoft.azure.management.batch.implementation.ApplicationImpl;
import com.microsoft.azure.management.batch.implementation.ApplicationsImpl;
import com.microsoft.azure.management.batch.implementation.BatchAccountCreateParametersInner;
import com.microsoft.azure.management.batch.implementation.BatchAccountInner;
import com.microsoft.azure.management.batch.implementation.BatchAccountKeysInner;
import com.microsoft.azure.management.batch.implementation.BatchManagementClientImpl;
import com.microsoft.azure.management.batch.implementation.BatchManager;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import com.microsoft.azure.management.storage.StorageAccount;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import java.util.List;
import java.util.Map;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class BatchAccountImpl
extends GroupableResourceImpl<BatchAccount, BatchAccountInner, BatchAccountImpl, BatchManager>
implements BatchAccount,
BatchAccount.Definition,
BatchAccount.Update {
    private final StorageManager storageManager;
    private String creatableStorageAccountKey;
    private StorageAccount existingStorageAccountToAssociate;
    private ApplicationsImpl applicationsImpl;
    private AutoStorageProperties autoStorage;

    protected BatchAccountImpl(String name, BatchAccountInner innerObject, BatchManager manager, StorageManager storageManager) {
        super(name, (Resource)innerObject, (ManagerBase)manager);
        this.storageManager = storageManager;
        this.applicationsImpl = new ApplicationsImpl(this);
    }

    public Observable<BatchAccount> refreshAsync() {
        return super.refreshAsync().map((Func1)new Func1<BatchAccount, BatchAccount>(){

            public BatchAccount call(BatchAccount batchAccount) {
                BatchAccountImpl impl = (BatchAccountImpl)batchAccount;
                impl.applicationsImpl.refresh();
                return impl;
            }
        });
    }

    protected Observable<BatchAccountInner> getInnerAsync() {
        return ((BatchManagementClientImpl)((Object)((BatchManager)this.manager()).inner())).batchAccounts().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public Observable<BatchAccount> createResourceAsync() {
        final BatchAccountImpl self = this;
        this.handleStorageSettings();
        BatchAccountCreateParametersInner batchAccountCreateParametersInner = new BatchAccountCreateParametersInner();
        if (this.autoStorage != null) {
            batchAccountCreateParametersInner.withAutoStorage(new AutoStorageBaseProperties());
            batchAccountCreateParametersInner.autoStorage().withStorageAccountId(this.autoStorage.storageAccountId());
        } else {
            batchAccountCreateParametersInner.withAutoStorage(null);
        }
        batchAccountCreateParametersInner.withLocation(((BatchAccountInner)((Object)this.inner())).location());
        batchAccountCreateParametersInner.withTags(((BatchAccountInner)((Object)this.inner())).getTags());
        return ((BatchManagementClientImpl)((Object)((BatchManager)this.manager()).inner())).batchAccounts().createAsync(this.resourceGroupName(), this.name(), batchAccountCreateParametersInner).map((Func1)new Func1<BatchAccountInner, BatchAccount>(){

            public BatchAccount call(BatchAccountInner batchAccountInner) {
                self.creatableStorageAccountKey = null;
                BatchAccountImpl.this.setInner((Object)batchAccountInner);
                return self;
            }
        }).flatMap((Func1)new Func1<BatchAccount, Observable<? extends BatchAccount>>(){

            public Observable<? extends BatchAccount> call(BatchAccount batchAccount) {
                return self.applicationsImpl.commitAndGetAllAsync().map((Func1)new Func1<List<ApplicationImpl>, BatchAccount>(){

                    public BatchAccount call(List<ApplicationImpl> applications) {
                        return self;
                    }
                });
            }
        });
    }

    public Observable<BatchAccount> updateResourceAsync() {
        return this.createResourceAsync();
    }

    @Override
    public ProvisioningState provisioningState() {
        return ((BatchAccountInner)((Object)this.inner())).provisioningState();
    }

    @Override
    public String accountEndpoint() {
        return ((BatchAccountInner)((Object)this.inner())).accountEndpoint();
    }

    @Override
    public AutoStorageProperties autoStorage() {
        return ((BatchAccountInner)((Object)this.inner())).autoStorage();
    }

    @Override
    public int coreQuota() {
        return Utils.toPrimitiveInt((Integer)((BatchAccountInner)((Object)this.inner())).dedicatedCoreQuota());
    }

    @Override
    public int poolQuota() {
        return Utils.toPrimitiveInt((Integer)((BatchAccountInner)((Object)this.inner())).poolQuota());
    }

    @Override
    public int activeJobAndJobScheduleQuota() {
        return Utils.toPrimitiveInt((Integer)((BatchAccountInner)((Object)this.inner())).activeJobAndJobScheduleQuota());
    }

    @Override
    public BatchAccountKeys getKeys() {
        BatchAccountKeysInner keys = ((BatchManagementClientImpl)((Object)((BatchManager)this.manager()).inner())).batchAccounts().getKeys(this.resourceGroupName(), this.name());
        return new BatchAccountKeys(keys.primary(), keys.secondary());
    }

    @Override
    public BatchAccountKeys regenerateKeys(AccountKeyType keyType) {
        BatchAccountKeysInner keys = ((BatchManagementClientImpl)((Object)((BatchManager)this.manager()).inner())).batchAccounts().regenerateKey(this.resourceGroupName(), this.name(), keyType);
        return new BatchAccountKeys(keys.primary(), keys.secondary());
    }

    @Override
    public void synchronizeAutoStorageKeys() {
        ((BatchManagementClientImpl)((Object)((BatchManager)this.manager()).inner())).batchAccounts().synchronizeAutoStorageKeys(this.resourceGroupName(), this.name());
    }

    @Override
    public Map<String, Application> applications() {
        return this.applicationsImpl.asMap();
    }

    @Override
    public BatchAccountImpl withExistingStorageAccount(StorageAccount storageAccount) {
        this.existingStorageAccountToAssociate = storageAccount;
        this.creatableStorageAccountKey = null;
        return this;
    }

    @Override
    public BatchAccountImpl withNewStorageAccount(Creatable<StorageAccount> creatable) {
        if (this.creatableStorageAccountKey == null) {
            this.creatableStorageAccountKey = creatable.key();
            this.addCreatableDependency(creatable);
        }
        this.existingStorageAccountToAssociate = null;
        return this;
    }

    @Override
    public BatchAccountImpl withNewStorageAccount(String storageAccountName) {
        StorageAccount.DefinitionStages.WithGroup definitionWithGroup = (StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.storageManager.storageAccounts().define(storageAccountName)).withRegion(this.regionName());
        Creatable definitionAfterGroup = this.creatableGroup != null ? (Creatable)definitionWithGroup.withNewResourceGroup(this.creatableGroup) : (Creatable)definitionWithGroup.withExistingResourceGroup(this.resourceGroupName());
        return this.withNewStorageAccount(definitionAfterGroup);
    }

    @Override
    public BatchAccountImpl withoutStorageAccount() {
        this.existingStorageAccountToAssociate = null;
        this.creatableStorageAccountKey = null;
        this.autoStorage = null;
        return this;
    }

    public ApplicationImpl defineNewApplication(String applicationId) {
        return this.applicationsImpl.define(applicationId);
    }

    @Override
    public ApplicationImpl updateApplication(String applicationId) {
        return this.applicationsImpl.update(applicationId);
    }

    @Override
    public BatchAccount.Update withoutApplication(String applicationId) {
        this.applicationsImpl.remove(applicationId);
        return this;
    }

    private void handleStorageSettings() {
        StorageAccount storageAccount;
        if (this.creatableStorageAccountKey != null) {
            this.existingStorageAccountToAssociate = storageAccount = (StorageAccount)this.createdResource(this.creatableStorageAccountKey);
        } else if (this.existingStorageAccountToAssociate != null) {
            storageAccount = this.existingStorageAccountToAssociate;
        } else {
            return;
        }
        if (this.autoStorage == null) {
            this.autoStorage = new AutoStorageProperties();
        }
        this.autoStorage.withStorageAccountId(storageAccount.id());
    }

    BatchAccountImpl withApplication(ApplicationImpl application) {
        this.applicationsImpl.addApplication(application);
        return this;
    }
}

