/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The file system to mount on each node.
 */
public class MountConfiguration {
    /**
     * The Azure Storage Container to mount using blob FUSE on each node.
     * This property is mutually exclusive with all other properties.
     */
    @JsonProperty(value = "azureBlobFileSystemConfiguration")
    private AzureBlobFileSystemConfiguration azureBlobFileSystemConfiguration;

    /**
     * The NFS file system to mount on each node.
     * This property is mutually exclusive with all other properties.
     */
    @JsonProperty(value = "nfsMountConfiguration")
    private NFSMountConfiguration nfsMountConfiguration;

    /**
     * The CIFS/SMB file system to mount on each node.
     * This property is mutually exclusive with all other properties.
     */
    @JsonProperty(value = "cifsMountConfiguration")
    private CIFSMountConfiguration cifsMountConfiguration;

    /**
     * The Azure File Share to mount on each node.
     * This property is mutually exclusive with all other properties.
     */
    @JsonProperty(value = "azureFileShareConfiguration")
    private AzureFileShareConfiguration azureFileShareConfiguration;

    /**
     * Get this property is mutually exclusive with all other properties.
     *
     * @return the azureBlobFileSystemConfiguration value
     */
    public AzureBlobFileSystemConfiguration azureBlobFileSystemConfiguration() {
        return this.azureBlobFileSystemConfiguration;
    }

    /**
     * Set this property is mutually exclusive with all other properties.
     *
     * @param azureBlobFileSystemConfiguration the azureBlobFileSystemConfiguration value to set
     * @return the MountConfiguration object itself.
     */
    public MountConfiguration withAzureBlobFileSystemConfiguration(AzureBlobFileSystemConfiguration azureBlobFileSystemConfiguration) {
        this.azureBlobFileSystemConfiguration = azureBlobFileSystemConfiguration;
        return this;
    }

    /**
     * Get this property is mutually exclusive with all other properties.
     *
     * @return the nfsMountConfiguration value
     */
    public NFSMountConfiguration nfsMountConfiguration() {
        return this.nfsMountConfiguration;
    }

    /**
     * Set this property is mutually exclusive with all other properties.
     *
     * @param nfsMountConfiguration the nfsMountConfiguration value to set
     * @return the MountConfiguration object itself.
     */
    public MountConfiguration withNfsMountConfiguration(NFSMountConfiguration nfsMountConfiguration) {
        this.nfsMountConfiguration = nfsMountConfiguration;
        return this;
    }

    /**
     * Get this property is mutually exclusive with all other properties.
     *
     * @return the cifsMountConfiguration value
     */
    public CIFSMountConfiguration cifsMountConfiguration() {
        return this.cifsMountConfiguration;
    }

    /**
     * Set this property is mutually exclusive with all other properties.
     *
     * @param cifsMountConfiguration the cifsMountConfiguration value to set
     * @return the MountConfiguration object itself.
     */
    public MountConfiguration withCifsMountConfiguration(CIFSMountConfiguration cifsMountConfiguration) {
        this.cifsMountConfiguration = cifsMountConfiguration;
        return this;
    }

    /**
     * Get this property is mutually exclusive with all other properties.
     *
     * @return the azureFileShareConfiguration value
     */
    public AzureFileShareConfiguration azureFileShareConfiguration() {
        return this.azureFileShareConfiguration;
    }

    /**
     * Set this property is mutually exclusive with all other properties.
     *
     * @param azureFileShareConfiguration the azureFileShareConfiguration value to set
     * @return the MountConfiguration object itself.
     */
    public MountConfiguration withAzureFileShareConfiguration(AzureFileShareConfiguration azureFileShareConfiguration) {
        this.azureFileShareConfiguration = azureFileShareConfiguration;
        return this;
    }

}
