/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The disks sku name. Can be Standard_LRS or Premium_LRS.
 */
public class DiskSku {
    /**
     * The sku name. Possible values include: 'Standard_LRS', 'Premium_LRS'.
     */
    @JsonProperty(value = "name")
    private StorageAccountTypes name;

    /**
     * The sku tier.
     */
    @JsonProperty(value = "tier", access = JsonProperty.Access.WRITE_ONLY)
    private String tier;

    /**
     * Get the name value.
     *
     * @return the name value
     */
    public StorageAccountTypes name() {
        return this.name;
    }

    /**
     * Set the name value.
     *
     * @param name the name value to set
     * @return the DiskSku object itself.
     */
    public DiskSku withName(StorageAccountTypes name) {
        this.name = name;
        return this;
    }

    /**
     * Get the tier value.
     *
     * @return the tier value
     */
    public String tier() {
        return this.tier;
    }

}
