/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.management.compute.IntervalInMins;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.azure.management.compute.LogAnalyticsInputBase;

/**
 * Api request input for LogAnalytics getRequestRateByInterval Api.
 */
public class RequestRateByIntervalInputInner extends LogAnalyticsInputBase {
    /**
     * Interval value in minutes used to create LogAnalytics call rate logs.
     * Possible values include: 'ThreeMins', 'FiveMins', 'ThirtyMins',
     * 'SixtyMins'.
     */
    @JsonProperty(value = "intervalLength", required = true)
    private IntervalInMins intervalLength;

    /**
     * Get the intervalLength value.
     *
     * @return the intervalLength value
     */
    public IntervalInMins intervalLength() {
        return this.intervalLength;
    }

    /**
     * Set the intervalLength value.
     *
     * @param intervalLength the intervalLength value to set
     * @return the RequestRateByIntervalInputInner object itself.
     */
    public RequestRateByIntervalInputInner withIntervalLength(IntervalInMins intervalLength) {
        this.intervalLength = intervalLength;
        return this;
    }

}
