/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerinstance.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.containerinstance.Container;
import com.microsoft.azure.management.containerinstance.ContainerExecRequest;
import com.microsoft.azure.management.containerinstance.ContainerExecRequestTerminalSize;
import com.microsoft.azure.management.containerinstance.ContainerExecResponse;
import com.microsoft.azure.management.containerinstance.ContainerGroup;
import com.microsoft.azure.management.containerinstance.ContainerGroupDiagnostics;
import com.microsoft.azure.management.containerinstance.ContainerGroupIpAddressType;
import com.microsoft.azure.management.containerinstance.ContainerGroupNetworkProfile;
import com.microsoft.azure.management.containerinstance.ContainerGroupNetworkProtocol;
import com.microsoft.azure.management.containerinstance.ContainerGroupRestartPolicy;
import com.microsoft.azure.management.containerinstance.DnsConfiguration;
import com.microsoft.azure.management.containerinstance.Event;
import com.microsoft.azure.management.containerinstance.ImageRegistryCredential;
import com.microsoft.azure.management.containerinstance.IpAddress;
import com.microsoft.azure.management.containerinstance.LogAnalytics;
import com.microsoft.azure.management.containerinstance.LogAnalyticsLogType;
import com.microsoft.azure.management.containerinstance.OperatingSystemTypes;
import com.microsoft.azure.management.containerinstance.Port;
import com.microsoft.azure.management.containerinstance.ResourceIdentityType;
import com.microsoft.azure.management.containerinstance.Volume;
import com.microsoft.azure.management.containerinstance.implementation.ContainerExecResponseImpl;
import com.microsoft.azure.management.containerinstance.implementation.ContainerExecResponseInner;
import com.microsoft.azure.management.containerinstance.implementation.ContainerGroupInner;
import com.microsoft.azure.management.containerinstance.implementation.ContainerGroupMsiHandler;
import com.microsoft.azure.management.containerinstance.implementation.ContainerImpl;
import com.microsoft.azure.management.containerinstance.implementation.ContainerInstanceManagementClientImpl;
import com.microsoft.azure.management.containerinstance.implementation.ContainerInstanceManager;
import com.microsoft.azure.management.containerinstance.implementation.VolumeImpl;
import com.microsoft.azure.management.graphrbac.BuiltInRole;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.graphrbac.implementation.RoleAssignmentHelper;
import com.microsoft.azure.management.msi.Identity;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableParentResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import com.microsoft.azure.management.storage.StorageAccount;
import com.microsoft.azure.management.storage.StorageAccountKey;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import com.microsoft.azure.storage.CloudStorageAccount;
import com.microsoft.azure.storage.file.CloudFileClient;
import com.microsoft.azure.storage.file.CloudFileShare;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.tuple.Triple;
import rx.Completable;
import rx.Observable;
import rx.exceptions.Exceptions;
import rx.functions.Action2;
import rx.functions.Func0;
import rx.functions.Func1;

@LangDefinition
public class ContainerGroupImpl
extends GroupableParentResourceImpl<ContainerGroup, ContainerGroupInner, ContainerGroupImpl, ContainerInstanceManager>
implements ContainerGroup,
ContainerGroup.Definition,
ContainerGroup.Update {
    private final StorageManager storageManager;
    private String creatableStorageAccountKey;
    private Map<String, String> newFileShares;
    private Map<String, Container> containers;
    private Map<String, Volume> volumes;
    private List<String> imageRegistryServers;
    private int[] externalTcpPorts;
    private int[] externalUdpPorts;
    private ContainerGroupMsiHandler containerGroupMsiHandler;

    protected ContainerGroupImpl(String name, ContainerGroupInner innerObject, ContainerInstanceManager manager, StorageManager storageManager, GraphRbacManager rbacManager) {
        super(name, (Resource)innerObject, (ManagerBase)manager);
        this.storageManager = storageManager;
        this.containerGroupMsiHandler = new ContainerGroupMsiHandler(rbacManager, this);
    }

    protected void beforeCreating() {
    }

    protected Observable<ContainerGroupInner> createInner() {
        this.containerGroupMsiHandler.processCreatedExternalIdentities();
        this.containerGroupMsiHandler.handleExternalIdentities();
        final ContainerGroupImpl self = this;
        if (!this.isInCreateMode()) {
            Resource resource = new Resource();
            resource.withLocation(self.regionName());
            resource.withTags(self.tags());
            return ((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)self.manager()).inner())).containerGroups().updateAsync(self.resourceGroupName(), self.name(), resource).flatMap((Func1)new Func1<ContainerGroupInner, Observable<ContainerGroupInner>>(){

                public Observable<ContainerGroupInner> call(ContainerGroupInner containerGroupInner) {
                    return ((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)self.manager()).inner())).containerGroups().getByResourceGroupAsync(self.resourceGroupName(), self.name());
                }
            });
        }
        if (this.newFileShares == null || this.creatableStorageAccountKey == null) {
            return ((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)self.manager()).inner())).containerGroups().createOrUpdateAsync(self.resourceGroupName(), self.name(), (ContainerGroupInner)((Object)self.inner()));
        }
        final StorageAccount storageAccount = (StorageAccount)this.taskResult(this.creatableStorageAccountKey);
        return this.createFileShareAsync(storageAccount).collect((Func0)new Func0<List<Triple<String, String, String>>>(){

            public List<Triple<String, String, String>> call() {
                return new ArrayList<Triple<String, String, String>>();
            }
        }, (Action2)new Action2<List<Triple<String, String, String>>, Triple<String, String, String>>(){

            public void call(List<Triple<String, String, String>> cloudFileShares, Triple<String, String, String> fileShare) {
                cloudFileShares.add(fileShare);
            }
        }).flatMap((Func1)new Func1<List<Triple<String, String, String>>, Observable<? extends ContainerGroupInner>>(){

            public Observable<? extends ContainerGroupInner> call(List<Triple<String, String, String>> fileShares) {
                for (Triple<String, String, String> fileShareEntry : fileShares) {
                    self.defineVolume((String)fileShareEntry.getLeft()).withExistingReadWriteAzureFileShare((String)fileShareEntry.getMiddle()).withStorageAccountName(storageAccount.name()).withStorageAccountKey((String)fileShareEntry.getRight()).attach();
                }
                return ((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)self.manager()).inner())).containerGroups().createOrUpdateAsync(self.resourceGroupName(), self.name(), (ContainerGroupInner)((Object)self.inner()));
            }
        });
    }

    private Observable<Triple<String, String, String>> createFileShareAsync(final StorageAccount storageAccount) {
        return storageAccount.getKeysAsync().map((Func1)new Func1<List<StorageAccountKey>, String>(){

            public String call(List<StorageAccountKey> storageAccountKeys) {
                return storageAccountKeys.get(0).value();
            }
        }).flatMap((Func1)new Func1<String, Observable<Triple<String, String, String>>>(){
            CloudFileClient cloudFileClient;

            public Observable<Triple<String, String, String>> call(final String storageAccountKey) {
                try {
                    this.cloudFileClient = CloudStorageAccount.parse((String)String.format("DefaultEndpointsProtocol=https;AccountName=%s;AccountKey=%s;EndpointSuffix=core.windows.net", storageAccount.name(), storageAccountKey)).createCloudFileClient();
                }
                catch (URISyntaxException syntaxException) {
                    throw Exceptions.propagate((Throwable)syntaxException);
                }
                catch (InvalidKeyException keyException) {
                    throw Exceptions.propagate((Throwable)keyException);
                }
                return Observable.from(ContainerGroupImpl.this.newFileShares.entrySet()).flatMap((Func1)new Func1<Map.Entry<String, String>, Observable<Triple<String, String, String>>>(){

                    public Observable<Triple<String, String, String>> call(Map.Entry<String, String> fileShareEntry) {
                        return ContainerGroupImpl.this.createSingleFileShareAsync(cloudFileClient, fileShareEntry.getKey(), fileShareEntry.getValue(), storageAccountKey);
                    }
                });
            }
        });
    }

    private Observable<Triple<String, String, String>> createSingleFileShareAsync(final CloudFileClient client, final String volumeName, final String fileShareName, final String storageAccountKey) {
        return Observable.fromCallable((Callable)new Callable<Triple<String, String, String>>(){

            @Override
            public Triple<String, String, String> call() throws Exception {
                CloudFileShare cloudFileShare = client.getShareReference(fileShareName);
                cloudFileShare.createIfNotExists();
                return Triple.of((Object)volumeName, (Object)fileShareName, (Object)storageAccountKey);
            }
        });
    }

    protected void afterCreating() {
        this.initializeChildrenFromInner();
    }

    protected void initializeChildrenFromInner() {
        this.containers = new HashMap<String, Container>();
        if (((ContainerGroupInner)((Object)this.inner())).containers() != null && ((ContainerGroupInner)((Object)this.inner())).containers().size() > 0) {
            for (Container containerInstance : ((ContainerGroupInner)((Object)this.inner())).containers()) {
                this.containers.put(containerInstance.name(), containerInstance);
            }
        }
        this.volumes = new HashMap<String, Volume>();
        if (((ContainerGroupInner)((Object)this.inner())).volumes() != null && ((ContainerGroupInner)((Object)this.inner())).volumes().size() > 0) {
            for (Volume volume : ((ContainerGroupInner)((Object)this.inner())).volumes()) {
                this.volumes.put(volume.name(), volume);
            }
        }
        this.imageRegistryServers = new ArrayList<String>();
        if (((ContainerGroupInner)((Object)this.inner())).imageRegistryCredentials() != null && ((ContainerGroupInner)((Object)this.inner())).imageRegistryCredentials().size() > 0) {
            for (ImageRegistryCredential imageRegistry : ((ContainerGroupInner)((Object)this.inner())).imageRegistryCredentials()) {
                this.imageRegistryServers.add(imageRegistry.server());
            }
        }
        if (((ContainerGroupInner)((Object)this.inner())).ipAddress() != null && ((ContainerGroupInner)((Object)this.inner())).ipAddress().ports() != null) {
            int i;
            ArrayList<Port> tcpPorts = new ArrayList<Port>();
            ArrayList<Port> udpPorts = new ArrayList<Port>();
            for (Port port : ((ContainerGroupInner)((Object)this.inner())).ipAddress().ports()) {
                if (port.protocol().equals((Object)ContainerGroupNetworkProtocol.TCP)) {
                    tcpPorts.add(port);
                    continue;
                }
                if (!port.protocol().equals((Object)ContainerGroupNetworkProtocol.UDP)) continue;
                udpPorts.add(port);
            }
            this.externalTcpPorts = new int[tcpPorts.size()];
            for (i = 0; i < this.externalTcpPorts.length; ++i) {
                this.externalTcpPorts[i] = ((Port)tcpPorts.get(i)).port();
            }
            this.externalUdpPorts = new int[udpPorts.size()];
            for (i = 0; i < this.externalTcpPorts.length; ++i) {
                this.externalTcpPorts[i] = ((Port)tcpPorts.get(i)).port();
            }
        } else {
            this.externalTcpPorts = new int[0];
            this.externalUdpPorts = new int[0];
        }
    }

    public Observable<ContainerGroup> refreshAsync() {
        return super.refreshAsync().map((Func1)new Func1<ContainerGroup, ContainerGroup>(){

            public ContainerGroup call(ContainerGroup containerGroup) {
                ContainerGroupImpl impl = (ContainerGroupImpl)containerGroup;
                impl.initializeChildrenFromInner();
                return impl;
            }
        });
    }

    protected Observable<ContainerGroupInner> getInnerAsync() {
        return ((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)this.manager()).inner())).containerGroups().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public ContainerGroupImpl withLinux() {
        ((ContainerGroupInner)((Object)this.inner())).withOsType(OperatingSystemTypes.LINUX);
        return this;
    }

    @Override
    public ContainerGroupImpl withWindows() {
        ((ContainerGroupInner)((Object)this.inner())).withOsType(OperatingSystemTypes.WINDOWS);
        return this;
    }

    @Override
    public ContainerGroupImpl withSystemAssignedManagedServiceIdentity() {
        this.containerGroupMsiHandler.withLocalManagedServiceIdentity();
        return this;
    }

    @Override
    public ContainerGroupImpl withSystemAssignedIdentityBasedAccessTo(String resourceId, BuiltInRole role) {
        this.containerGroupMsiHandler.withAccessTo(resourceId, role);
        return this;
    }

    @Override
    public ContainerGroupImpl withSystemAssignedIdentityBasedAccessToCurrentResourceGroup(BuiltInRole role) {
        this.containerGroupMsiHandler.withAccessToCurrentResourceGroup(role);
        return this;
    }

    @Override
    public ContainerGroupImpl withSystemAssignedIdentityBasedAccessTo(String resourceId, String roleDefinitionId) {
        this.containerGroupMsiHandler.withAccessTo(resourceId, roleDefinitionId);
        return this;
    }

    @Override
    public ContainerGroupImpl withSystemAssignedIdentityBasedAccessToCurrentResourceGroup(String roleDefinitionId) {
        this.containerGroupMsiHandler.withAccessToCurrentResourceGroup(roleDefinitionId);
        return this;
    }

    @Override
    public ContainerGroupImpl withNewUserAssignedManagedServiceIdentity(Creatable<Identity> creatableIdentity) {
        this.containerGroupMsiHandler.withNewExternalManagedServiceIdentity(creatableIdentity);
        return this;
    }

    @Override
    public ContainerGroupImpl withExistingUserAssignedManagedServiceIdentity(Identity identity) {
        this.containerGroupMsiHandler.withExistingExternalManagedServiceIdentity(identity);
        return this;
    }

    @Override
    public ContainerGroupImpl withPublicImageRegistryOnly() {
        ((ContainerGroupInner)((Object)this.inner())).withImageRegistryCredentials(null);
        return this;
    }

    @Override
    public ContainerGroupImpl withPrivateImageRegistry(String server, String username, String password) {
        if (((ContainerGroupInner)((Object)this.inner())).imageRegistryCredentials() == null) {
            ((ContainerGroupInner)((Object)this.inner())).withImageRegistryCredentials(new ArrayList<ImageRegistryCredential>());
        }
        ((ContainerGroupInner)((Object)this.inner())).imageRegistryCredentials().add(new ImageRegistryCredential().withServer(server).withUsername(username).withPassword(password));
        return this;
    }

    @Override
    public ContainerGroupImpl withNewAzureFileShareVolume(String volumeName, String shareName) {
        if (this.newFileShares == null || this.creatableStorageAccountKey == null) {
            StorageAccount.DefinitionStages.WithGroup definitionWithGroup = (StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.storageManager.storageAccounts().define(SdkContext.randomResourceName((String)"fs", (int)24))).withRegion(this.regionName());
            Creatable creatable = this.creatableGroup != null ? (Creatable)definitionWithGroup.withNewResourceGroup(this.creatableGroup) : (Creatable)definitionWithGroup.withExistingResourceGroup(this.resourceGroupName());
            this.creatableStorageAccountKey = this.addDependency(creatable);
            this.newFileShares = new HashMap<String, String>();
        }
        this.newFileShares.put(volumeName, shareName);
        return this;
    }

    @Override
    public ContainerGroupImpl withEmptyDirectoryVolume(String volumeName) {
        if (((ContainerGroupInner)((Object)this.inner())).volumes() == null) {
            ((ContainerGroupInner)((Object)this.inner())).withVolumes(new ArrayList<Volume>());
        }
        ((ContainerGroupInner)((Object)this.inner())).volumes().add(new Volume().withName(volumeName).withEmptyDir(new Object()));
        return this;
    }

    public VolumeImpl defineVolume(String name) {
        return new VolumeImpl(this, name);
    }

    @Override
    public ContainerGroupImpl withoutVolume() {
        ((ContainerGroupInner)((Object)this.inner())).withVolumes(null);
        return this;
    }

    public ContainerImpl defineContainerInstance(String name) {
        return new ContainerImpl(this, name);
    }

    @Override
    public ContainerGroupImpl withContainerInstance(String imageName) {
        return this.defineContainerInstance(this.name()).withImage(imageName).withoutPorts().withCpuCoreCount(1.0).withMemorySizeInGB(1.5).attach();
    }

    @Override
    public ContainerGroupImpl withContainerInstance(String imageName, int port) {
        return this.defineContainerInstance(this.name()).withImage(imageName).withExternalTcpPort(port).withCpuCoreCount(1.0).withMemorySizeInGB(1.5).attach();
    }

    @Override
    public ContainerGroupImpl withRestartPolicy(ContainerGroupRestartPolicy restartPolicy) {
        ((ContainerGroupInner)((Object)this.inner())).withRestartPolicy(restartPolicy);
        return this;
    }

    @Override
    public ContainerGroupImpl withDnsPrefix(String dnsPrefix) {
        if (((ContainerGroupInner)((Object)this.inner())).ipAddress() == null) {
            ((ContainerGroupInner)((Object)this.inner())).withIpAddress(new IpAddress());
        }
        ((ContainerGroupInner)((Object)this.inner())).ipAddress().withDnsNameLabel(dnsPrefix).withType(ContainerGroupIpAddressType.PUBLIC);
        return this;
    }

    @Override
    public ContainerGroupImpl withNetworkProfileId(String subscriptionId, String resourceGroupName, String networkProfileName) {
        String networkProfileId = "/subscriptions/" + subscriptionId + "/resourceGroups/" + resourceGroupName + "/providers/Microsoft.Network/networkProfiles/" + networkProfileName;
        ((ContainerGroupInner)((Object)this.inner())).withNetworkProfile(new ContainerGroupNetworkProfile().withId(networkProfileId));
        if (((ContainerGroupInner)((Object)this.inner())).ipAddress() == null) {
            ((ContainerGroupInner)((Object)this.inner())).withIpAddress(new IpAddress());
        }
        ((ContainerGroupInner)((Object)this.inner())).ipAddress().withType(ContainerGroupIpAddressType.PRIVATE);
        return this;
    }

    @Override
    public ContainerGroupImpl withDnsServerNames(List<String> dnsServerNames) {
        ((ContainerGroupInner)((Object)this.inner())).withDnsConfig(new DnsConfiguration().withNameServers(dnsServerNames));
        return this;
    }

    @Override
    public ContainerGroupImpl withDnsConfiguration(List<String> dnsServerNames, String dnsSearchDomains, String dnsOptions) {
        ((ContainerGroupInner)((Object)this.inner())).withDnsConfig(new DnsConfiguration().withNameServers(dnsServerNames).withSearchDomains(dnsSearchDomains).withOptions(dnsOptions));
        return this;
    }

    @Override
    public ContainerGroupImpl withLogAnalytics(String workspaceId, String workspaceKey) {
        ((ContainerGroupInner)((Object)this.inner())).withDiagnostics(new ContainerGroupDiagnostics().withLogAnalytics(new LogAnalytics().withWorkspaceId(workspaceId).withWorkspaceKey(workspaceKey)));
        return this;
    }

    @Override
    public ContainerGroupImpl withLogAnalytics(String workspaceId, String workspaceKey, LogAnalyticsLogType logType, Map<String, String> metadata) {
        ((ContainerGroupInner)((Object)this.inner())).withDiagnostics(new ContainerGroupDiagnostics().withLogAnalytics(new LogAnalytics().withWorkspaceId(workspaceId).withWorkspaceKey(workspaceKey).withLogType(logType).withMetadata(metadata)));
        return this;
    }

    @Override
    public Map<String, Container> containers() {
        return Collections.unmodifiableMap(this.containers);
    }

    @Override
    public Set<Port> externalPorts() {
        return Collections.unmodifiableSet(((ContainerGroupInner)((Object)this.inner())).ipAddress() != null && ((ContainerGroupInner)((Object)this.inner())).ipAddress().ports() != null ? new HashSet<Port>(((ContainerGroupInner)((Object)this.inner())).ipAddress().ports()) : new HashSet<Port>());
    }

    @Override
    public int[] externalTcpPorts() {
        return this.externalTcpPorts;
    }

    @Override
    public int[] externalUdpPorts() {
        return this.externalUdpPorts;
    }

    @Override
    public Map<String, Volume> volumes() {
        return Collections.unmodifiableMap(this.volumes);
    }

    @Override
    public Collection<String> imageRegistryServers() {
        return Collections.unmodifiableCollection(this.imageRegistryServers);
    }

    @Override
    public ContainerGroupRestartPolicy restartPolicy() {
        return ((ContainerGroupInner)((Object)this.inner())).restartPolicy();
    }

    @Override
    public String dnsPrefix() {
        if (((ContainerGroupInner)((Object)this.inner())).ipAddress() != null) {
            return ((ContainerGroupInner)((Object)this.inner())).ipAddress().dnsNameLabel();
        }
        return null;
    }

    @Override
    public String fqdn() {
        if (((ContainerGroupInner)((Object)this.inner())).ipAddress() != null) {
            return ((ContainerGroupInner)((Object)this.inner())).ipAddress().fqdn();
        }
        return null;
    }

    @Override
    public String ipAddress() {
        if (((ContainerGroupInner)((Object)this.inner())).ipAddress() != null) {
            return ((ContainerGroupInner)((Object)this.inner())).ipAddress().ip();
        }
        return null;
    }

    @Override
    public boolean isIPAddressPublic() {
        return ((ContainerGroupInner)((Object)this.inner())).ipAddress() != null && ((ContainerGroupInner)((Object)this.inner())).ipAddress().type() != null && ((ContainerGroupInner)((Object)this.inner())).ipAddress().type() == ContainerGroupIpAddressType.PUBLIC;
    }

    @Override
    public boolean isIPAddressPrivate() {
        return ((ContainerGroupInner)((Object)this.inner())).ipAddress() != null && ((ContainerGroupInner)((Object)this.inner())).ipAddress().type() != null && ((ContainerGroupInner)((Object)this.inner())).ipAddress().type() == ContainerGroupIpAddressType.PRIVATE;
    }

    @Override
    public OperatingSystemTypes osType() {
        return ((ContainerGroupInner)((Object)this.inner())).osType();
    }

    @Override
    public String state() {
        if (((ContainerGroupInner)((Object)this.inner())).instanceView() != null && ((ContainerGroupInner)((Object)this.inner())).instanceView().state() != null) {
            return ((ContainerGroupInner)((Object)this.inner())).instanceView().state();
        }
        return null;
    }

    @Override
    public String provisioningState() {
        if (((ContainerGroupInner)((Object)this.inner())).provisioningState() != null) {
            return ((ContainerGroupInner)((Object)this.inner())).provisioningState();
        }
        return null;
    }

    @Override
    public Set<Event> events() {
        return Collections.unmodifiableSet(((ContainerGroupInner)((Object)this.inner())).instanceView() != null && ((ContainerGroupInner)((Object)this.inner())).instanceView().events() != null ? new HashSet<Event>(((ContainerGroupInner)((Object)this.inner())).instanceView().events()) : new HashSet<Event>());
    }

    @Override
    public DnsConfiguration dnsConfig() {
        return ((ContainerGroupInner)((Object)this.inner())).dnsConfig();
    }

    @Override
    public String networkProfileId() {
        return ((ContainerGroupInner)((Object)this.inner())).networkProfile().id();
    }

    @Override
    public boolean isManagedServiceIdentityEnabled() {
        ResourceIdentityType type = this.managedServiceIdentityType();
        return type != null && !type.equals((Object)ResourceIdentityType.NONE);
    }

    @Override
    public String systemAssignedManagedServiceIdentityTenantId() {
        if (((ContainerGroupInner)((Object)this.inner())).identity() != null) {
            return ((ContainerGroupInner)((Object)this.inner())).identity().tenantId();
        }
        return null;
    }

    @Override
    public String systemAssignedManagedServiceIdentityPrincipalId() {
        if (((ContainerGroupInner)((Object)this.inner())).identity() != null) {
            return ((ContainerGroupInner)((Object)this.inner())).identity().principalId();
        }
        return null;
    }

    @Override
    public ResourceIdentityType managedServiceIdentityType() {
        if (((ContainerGroupInner)((Object)this.inner())).identity() != null) {
            return ((ContainerGroupInner)((Object)this.inner())).identity().type();
        }
        return null;
    }

    @Override
    public Set<String> userAssignedManagedServiceIdentityIds() {
        if (((ContainerGroupInner)((Object)this.inner())).identity() != null && ((ContainerGroupInner)((Object)this.inner())).identity().userAssignedIdentities() != null) {
            return Collections.unmodifiableSet(new HashSet<String>(((ContainerGroupInner)((Object)this.inner())).identity().userAssignedIdentities().keySet()));
        }
        return Collections.unmodifiableSet(new HashSet());
    }

    @Override
    public LogAnalytics logAnalytics() {
        return ((ContainerGroupInner)((Object)this.inner())).diagnostics().logAnalytics();
    }

    @Override
    public void restart() {
        ((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)this.manager()).inner())).containerGroups().restart(this.resourceGroupName(), this.name());
    }

    @Override
    public Completable restartAsync() {
        return ((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)this.manager()).inner())).containerGroups().restartAsync(this.resourceGroupName(), this.name()).toCompletable();
    }

    @Override
    public void stop() {
        ((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)this.manager()).inner())).containerGroups().stop(this.resourceGroupName(), this.name());
    }

    @Override
    public Completable stopAsync() {
        return ((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)this.manager()).inner())).containerGroups().stopAsync(this.resourceGroupName(), this.name()).toCompletable();
    }

    @Override
    public String getLogContent(String containerName) {
        return ((ContainerInstanceManager)this.manager()).containerGroups().getLogContent(this.resourceGroupName(), this.name(), containerName);
    }

    @Override
    public String getLogContent(String containerName, int tailLineCount) {
        return ((ContainerInstanceManager)this.manager()).containerGroups().getLogContent(this.resourceGroupName(), this.name(), containerName, tailLineCount);
    }

    @Override
    public Observable<String> getLogContentAsync(String containerName) {
        return ((ContainerInstanceManager)this.manager()).containerGroups().getLogContentAsync(this.resourceGroupName(), this.name(), containerName);
    }

    @Override
    public Observable<String> getLogContentAsync(String containerName, int tailLineCount) {
        return ((ContainerInstanceManager)this.manager()).containerGroups().getLogContentAsync(this.resourceGroupName(), this.name(), containerName, tailLineCount);
    }

    @Override
    public ContainerExecResponse executeCommand(String containerName, String command, int row, int column) {
        return new ContainerExecResponseImpl(((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)this.manager()).inner())).containers().executeCommand(this.resourceGroupName(), this.name(), containerName, new ContainerExecRequest().withCommand(command).withTerminalSize(new ContainerExecRequestTerminalSize().withRows(row).withCols(column))));
    }

    @Override
    public Observable<ContainerExecResponse> executeCommandAsync(String containerName, String command, int row, int column) {
        return ((ContainerInstanceManagementClientImpl)((Object)((ContainerInstanceManager)this.manager()).inner())).containers().executeCommandAsync(this.resourceGroupName(), this.name(), containerName, new ContainerExecRequest().withCommand(command).withTerminalSize(new ContainerExecRequestTerminalSize().withRows(row).withCols(column))).map((Func1)new Func1<ContainerExecResponseInner, ContainerExecResponse>(){

            public ContainerExecResponse call(ContainerExecResponseInner containerExecResponseInner) {
                return new ContainerExecResponseImpl(containerExecResponseInner);
            }
        });
    }

    RoleAssignmentHelper.IdProvider idProvider() {
        return new RoleAssignmentHelper.IdProvider(){

            public String principalId() {
                if (ContainerGroupImpl.this.inner() != null && ((ContainerGroupInner)((Object)ContainerGroupImpl.this.inner())).identity() != null) {
                    return ((ContainerGroupInner)((Object)ContainerGroupImpl.this.inner())).identity().principalId();
                }
                return null;
            }

            public String resourceId() {
                if (ContainerGroupImpl.this.inner() != null) {
                    return ((ContainerGroupInner)((Object)ContainerGroupImpl.this.inner())).id();
                }
                return null;
            }
        };
    }
}

