/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cosmosdb.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.cosmosdb.implementation.CosmosDBImpl;
import com.microsoft.azure.management.cosmosdb.implementation.MetricInner;
import com.microsoft.azure.management.cosmosdb.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class CollectionRegionsInner {
    private CollectionRegionsService service;
    private CosmosDBImpl client;

    public CollectionRegionsInner(Retrofit retrofit, CosmosDBImpl client) {
        this.service = (CollectionRegionsService)retrofit.create(CollectionRegionsService.class);
        this.client = client;
    }

    public List<MetricInner> listMetrics(String resourceGroupName, String accountName, String region, String databaseRid, String collectionRid, String filter) {
        return (List)((ServiceResponse)this.listMetricsWithServiceResponseAsync(resourceGroupName, accountName, region, databaseRid, collectionRid, filter).toBlocking().single()).body();
    }

    public ServiceFuture<List<MetricInner>> listMetricsAsync(String resourceGroupName, String accountName, String region, String databaseRid, String collectionRid, String filter, ServiceCallback<List<MetricInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listMetricsWithServiceResponseAsync(resourceGroupName, accountName, region, databaseRid, collectionRid, filter), serviceCallback);
    }

    public Observable<List<MetricInner>> listMetricsAsync(String resourceGroupName, String accountName, String region, String databaseRid, String collectionRid, String filter) {
        return this.listMetricsWithServiceResponseAsync(resourceGroupName, accountName, region, databaseRid, collectionRid, filter).map((Func1)new Func1<ServiceResponse<List<MetricInner>>, List<MetricInner>>(){

            public List<MetricInner> call(ServiceResponse<List<MetricInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<MetricInner>>> listMetricsWithServiceResponseAsync(String resourceGroupName, String accountName, String region, String databaseRid, String collectionRid, String filter) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (region == null) {
            throw new IllegalArgumentException("Parameter region is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (collectionRid == null) {
            throw new IllegalArgumentException("Parameter collectionRid is required and cannot be null.");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Parameter filter is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.listMetrics(this.client.subscriptionId(), resourceGroupName, accountName, region, databaseRid, collectionRid, "2019-08-01", filter, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<MetricInner>>>>(){

            public Observable<ServiceResponse<List<MetricInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CollectionRegionsInner.this.listMetricsDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<MetricInner>> listMetricsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<MetricInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface CollectionRegionsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.CollectionRegions listMetrics"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/region/{region}/databases/{databaseRid}/collections/{collectionRid}/metrics")
        public Observable<Response<ResponseBody>> listMetrics(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="region") String var4, @Path(value="databaseRid") String var5, @Path(value="collectionRid") String var6, @Query(value="api-version") String var7, @Query(value="$filter") String var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);
    }
}

