/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cosmosdb.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.cosmosdb.implementation.CosmosDBImpl;
import com.microsoft.azure.management.cosmosdb.implementation.MetricDefinitionInner;
import com.microsoft.azure.management.cosmosdb.implementation.MetricInner;
import com.microsoft.azure.management.cosmosdb.implementation.PageImpl;
import com.microsoft.azure.management.cosmosdb.implementation.UsageInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class CollectionsInner {
    private CollectionsService service;
    private CosmosDBImpl client;

    public CollectionsInner(Retrofit retrofit, CosmosDBImpl client) {
        this.service = (CollectionsService)retrofit.create(CollectionsService.class);
        this.client = client;
    }

    public List<MetricInner> listMetrics(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter) {
        return (List)((ServiceResponse)this.listMetricsWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid, filter).toBlocking().single()).body();
    }

    public ServiceFuture<List<MetricInner>> listMetricsAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter, ServiceCallback<List<MetricInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listMetricsWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid, filter), serviceCallback);
    }

    public Observable<List<MetricInner>> listMetricsAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter) {
        return this.listMetricsWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid, filter).map((Func1)new Func1<ServiceResponse<List<MetricInner>>, List<MetricInner>>(){

            public List<MetricInner> call(ServiceResponse<List<MetricInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<MetricInner>>> listMetricsWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (collectionRid == null) {
            throw new IllegalArgumentException("Parameter collectionRid is required and cannot be null.");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Parameter filter is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.listMetrics(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, collectionRid, "2019-08-01", filter, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<MetricInner>>>>(){

            public Observable<ServiceResponse<List<MetricInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CollectionsInner.this.listMetricsDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<MetricInner>> listMetricsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<MetricInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<UsageInner> listUsages(String resourceGroupName, String accountName, String databaseRid, String collectionRid) {
        return (List)((ServiceResponse)this.listUsagesWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid).toBlocking().single()).body();
    }

    public ServiceFuture<List<UsageInner>> listUsagesAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, ServiceCallback<List<UsageInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listUsagesWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid), serviceCallback);
    }

    public Observable<List<UsageInner>> listUsagesAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid) {
        return this.listUsagesWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid).map((Func1)new Func1<ServiceResponse<List<UsageInner>>, List<UsageInner>>(){

            public List<UsageInner> call(ServiceResponse<List<UsageInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<UsageInner>>> listUsagesWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (collectionRid == null) {
            throw new IllegalArgumentException("Parameter collectionRid is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        String filter = null;
        return this.service.listUsages(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, collectionRid, "2019-08-01", filter, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<UsageInner>>>>(){

            public Observable<ServiceResponse<List<UsageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CollectionsInner.this.listUsagesDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public List<UsageInner> listUsages(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter) {
        return (List)((ServiceResponse)this.listUsagesWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid, filter).toBlocking().single()).body();
    }

    public ServiceFuture<List<UsageInner>> listUsagesAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter, ServiceCallback<List<UsageInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listUsagesWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid, filter), serviceCallback);
    }

    public Observable<List<UsageInner>> listUsagesAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter) {
        return this.listUsagesWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid, filter).map((Func1)new Func1<ServiceResponse<List<UsageInner>>, List<UsageInner>>(){

            public List<UsageInner> call(ServiceResponse<List<UsageInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<UsageInner>>> listUsagesWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String filter) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (collectionRid == null) {
            throw new IllegalArgumentException("Parameter collectionRid is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.listUsages(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, collectionRid, "2019-08-01", filter, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<UsageInner>>>>(){

            public Observable<ServiceResponse<List<UsageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CollectionsInner.this.listUsagesDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<UsageInner>> listUsagesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<UsageInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<MetricDefinitionInner> listMetricDefinitions(String resourceGroupName, String accountName, String databaseRid, String collectionRid) {
        return (List)((ServiceResponse)this.listMetricDefinitionsWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid).toBlocking().single()).body();
    }

    public ServiceFuture<List<MetricDefinitionInner>> listMetricDefinitionsAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, ServiceCallback<List<MetricDefinitionInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listMetricDefinitionsWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid), serviceCallback);
    }

    public Observable<List<MetricDefinitionInner>> listMetricDefinitionsAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid) {
        return this.listMetricDefinitionsWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid).map((Func1)new Func1<ServiceResponse<List<MetricDefinitionInner>>, List<MetricDefinitionInner>>(){

            public List<MetricDefinitionInner> call(ServiceResponse<List<MetricDefinitionInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<MetricDefinitionInner>>> listMetricDefinitionsWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (collectionRid == null) {
            throw new IllegalArgumentException("Parameter collectionRid is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.listMetricDefinitions(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, collectionRid, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<MetricDefinitionInner>>>>(){

            public Observable<ServiceResponse<List<MetricDefinitionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CollectionsInner.this.listMetricDefinitionsDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<MetricDefinitionInner>> listMetricDefinitionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<MetricDefinitionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface CollectionsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.Collections listMetrics"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/databases/{databaseRid}/collections/{collectionRid}/metrics")
        public Observable<Response<ResponseBody>> listMetrics(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Path(value="collectionRid") String var5, @Query(value="api-version") String var6, @Query(value="$filter") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.Collections listUsages"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/databases/{databaseRid}/collections/{collectionRid}/usages")
        public Observable<Response<ResponseBody>> listUsages(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Path(value="collectionRid") String var5, @Query(value="api-version") String var6, @Query(value="$filter") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.Collections listMetricDefinitions"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/databases/{databaseRid}/collections/{collectionRid}/metricDefinitions")
        public Observable<Response<ResponseBody>> listMetricDefinitions(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Path(value="collectionRid") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);
    }
}

